/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;

public class NotEmptyExpression
extends JsonPathBasedExpression {
    public NotEmptyExpression() {
        super(ExpressionType.not_empty);
    }

    public NotEmptyExpression(String path, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.not_empty, path, defaultResult, preoperation);
    }

    public NotEmptyExpression(String path, PreOperation<?> preoperation) {
        this(path, false, preoperation);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (!evaluatedNode.isTextual()) {
            return false;
        }
        String data = evaluatedNode.asText();
        return null != data && !data.isEmpty();
    }

    public static NotEmptyExpressionBuilder builder() {
        return new NotEmptyExpressionBuilder();
    }

    public static class NotEmptyExpressionBuilder {
        private String path;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        NotEmptyExpressionBuilder() {
        }

        public NotEmptyExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public NotEmptyExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public NotEmptyExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public NotEmptyExpression build() {
            return new NotEmptyExpression(this.path, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "NotEmptyExpression.NotEmptyExpressionBuilder(path=" + this.path + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

