/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.numeric;

import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.numeric.NumericPreOperation;

public class AddOperation
extends NumericPreOperation {
    public AddOperation() {
        super(PreOperationType.add);
    }

    public AddOperation(Number operand) {
        super(PreOperationType.add, operand);
    }

    @Override
    public long compute(long leftOperand, long rightOperand) {
        return Long.sum(leftOperand, rightOperand);
    }

    @Override
    public double compute(double leftOperand, double rightOperand) {
        return Double.sum(leftOperand, rightOperand);
    }

    public static AddOperationBuilder builder() {
        return new AddOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOperation)) {
            return false;
        }
        AddOperation other = (AddOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AddOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AddOperation(super=" + super.toString() + ")";
    }

    public static class AddOperationBuilder {
        private Number operand;

        AddOperationBuilder() {
        }

        public AddOperationBuilder operand(Number operand) {
            this.operand = operand;
            return this;
        }

        public AddOperation build() {
            return new AddOperation(this.operand);
        }

        public String toString() {
            return "AddOperation.AddOperationBuilder(operand=" + this.operand + ")";
        }
    }
}

