/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.OptionKeys;
import io.appform.jsonrules.expressions.array.ContainsAllExpression;
import io.appform.jsonrules.expressions.array.ContainsAnyExpression;
import io.appform.jsonrules.expressions.array.InExpression;
import io.appform.jsonrules.expressions.array.NotInExpression;
import io.appform.jsonrules.expressions.composite.AndExpression;
import io.appform.jsonrules.expressions.composite.NotExpression;
import io.appform.jsonrules.expressions.composite.OrExpression;
import io.appform.jsonrules.expressions.equality.EqualsExpression;
import io.appform.jsonrules.expressions.equality.NotEqualsExpression;
import io.appform.jsonrules.expressions.meta.ExistsExpression;
import io.appform.jsonrules.expressions.meta.NotExistsExpression;
import io.appform.jsonrules.expressions.numeric.GreaterThanEqualsExpression;
import io.appform.jsonrules.expressions.numeric.GreaterThanExpression;
import io.appform.jsonrules.expressions.numeric.LessThanEqualsExpression;
import io.appform.jsonrules.expressions.numeric.LessThanExpression;
import io.appform.jsonrules.expressions.string.EmptyExpression;
import io.appform.jsonrules.expressions.string.EndsWithExpression;
import io.appform.jsonrules.expressions.string.MatchesExpression;
import io.appform.jsonrules.expressions.string.NotEmptyExpression;
import io.appform.jsonrules.expressions.string.StartsWithExpression;
import java.util.Collections;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="equals", value=EqualsExpression.class), @JsonSubTypes.Type(name="not_equals", value=NotEqualsExpression.class), @JsonSubTypes.Type(name="greater_than", value=GreaterThanExpression.class), @JsonSubTypes.Type(name="greater_than_equals", value=GreaterThanEqualsExpression.class), @JsonSubTypes.Type(name="less_than", value=LessThanExpression.class), @JsonSubTypes.Type(name="less_than_equals", value=LessThanEqualsExpression.class), @JsonSubTypes.Type(name="and", value=AndExpression.class), @JsonSubTypes.Type(name="or", value=OrExpression.class), @JsonSubTypes.Type(name="not", value=NotExpression.class), @JsonSubTypes.Type(name="exists", value=ExistsExpression.class), @JsonSubTypes.Type(name="not_exists", value=NotExistsExpression.class), @JsonSubTypes.Type(name="empty", value=EmptyExpression.class), @JsonSubTypes.Type(name="not_empty", value=NotEmptyExpression.class), @JsonSubTypes.Type(name="starts_with", value=StartsWithExpression.class), @JsonSubTypes.Type(name="ends_with", value=EndsWithExpression.class), @JsonSubTypes.Type(name="matches", value=MatchesExpression.class), @JsonSubTypes.Type(name="in", value=InExpression.class), @JsonSubTypes.Type(name="not_in", value=NotInExpression.class), @JsonSubTypes.Type(name="contains_any", value=ContainsAnyExpression.class), @JsonSubTypes.Type(name="contains_all", value=ContainsAllExpression.class)})
public abstract class Expression {
    private final ExpressionType type;

    protected Expression(ExpressionType type) {
        this.type = type;
    }

    public boolean evaluate(JsonNode node) {
        return this.evaluate(node, Collections.emptyMap());
    }

    public boolean evaluate(JsonNode node, Map<OptionKeys, Object> options) {
        if (null == node) {
            node = MissingNode.getInstance();
        }
        return this.evaluate(ExpressionEvaluationContext.builder().node(node).options(options).build());
    }

    public abstract boolean evaluate(ExpressionEvaluationContext var1);

    public ExpressionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExpressionType this$type = this.getType();
        ExpressionType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Expression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpressionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Expression(type=" + (Object)((Object)this.getType()) + ")";
    }
}

