/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.array;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import java.util.Set;

public abstract class CollectionJsonPathBasedExpression
extends JsonPathBasedExpression {
    private Set<Object> values;

    protected CollectionJsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected CollectionJsonPathBasedExpression(ExpressionType type, String path, Set<Object> values, boolean defaultResult, PreOperation<?> preoperation) {
        super(type, path, defaultResult, preoperation);
        this.values = values;
    }

    @Override
    protected final boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (null == this.values || this.values.isEmpty()) {
            return false;
        }
        return this.evaluate(evaluatedNode, this.values);
    }

    protected abstract boolean evaluate(JsonNode var1, Set<Object> var2);

    public Set<Object> getValues() {
        return this.values;
    }

    public void setValues(Set<Object> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionJsonPathBasedExpression)) {
            return false;
        }
        CollectionJsonPathBasedExpression other = (CollectionJsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<Object> this$values = this.getValues();
        Set<Object> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CollectionJsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Set<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CollectionJsonPathBasedExpression(super=" + super.toString() + ", values=" + this.getValues() + ")";
    }
}

