/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.google.common.base.Strings;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.string.StringJsonPathBasedExpression;

public class StartsWithExpression
extends StringJsonPathBasedExpression {
    public StartsWithExpression() {
        super(ExpressionType.starts_with);
    }

    public StartsWithExpression(String path, String value, boolean ignoreCase, boolean extractValueFromPath, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.starts_with, path, value, ignoreCase, extractValueFromPath, defaultResult, preoperation);
    }

    @Override
    protected boolean evaluate(String leftValue, String rightValue, boolean ignoreCase) {
        if (!Strings.isNullOrEmpty((String)leftValue) && !Strings.isNullOrEmpty((String)rightValue)) {
            if (ignoreCase) {
                return leftValue.toLowerCase().startsWith(rightValue.toLowerCase());
            }
            return leftValue.startsWith(rightValue);
        }
        return false;
    }

    public static StartsWithExpressionBuilder builder() {
        return new StartsWithExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartsWithExpression)) {
            return false;
        }
        StartsWithExpression other = (StartsWithExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StartsWithExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "StartsWithExpression(super=" + super.toString() + ")";
    }

    public static class StartsWithExpressionBuilder {
        private String path;
        private String value;
        private boolean ignoreCase;
        private boolean extractValueFromPath;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        StartsWithExpressionBuilder() {
        }

        public StartsWithExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public StartsWithExpressionBuilder value(String value) {
            this.value = value;
            return this;
        }

        public StartsWithExpressionBuilder ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public StartsWithExpressionBuilder extractValueFromPath(boolean extractValueFromPath) {
            this.extractValueFromPath = extractValueFromPath;
            return this;
        }

        public StartsWithExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public StartsWithExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public StartsWithExpression build() {
            return new StartsWithExpression(this.path, this.value, this.ignoreCase, this.extractValueFromPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "StartsWithExpression.StartsWithExpressionBuilder(path=" + this.path + ", value=" + this.value + ", ignoreCase=" + this.ignoreCase + ", extractValueFromPath=" + this.extractValueFromPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

