/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.ExpressionEvaluationContext;

public interface ComparisonUtils {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static int compare(JsonNode evaluatedNode, Object value) {
        int comparisonResult = 0;
        if (evaluatedNode.isNumber()) {
            return ComparisonUtils.compare(evaluatedNode, (Number)value);
        }
        if (evaluatedNode.isBoolean()) {
            return ComparisonUtils.compare(evaluatedNode, Boolean.parseBoolean(value.toString()));
        }
        if (evaluatedNode.isTextual()) {
            return ComparisonUtils.compare(evaluatedNode, String.valueOf(value));
        }
        if (evaluatedNode.isObject()) {
            throw new IllegalArgumentException("Object comparisons not supported");
        }
        return comparisonResult;
    }

    public static int compare(JsonNode evaluatedNode, Number value) {
        int comparisonResult = 0;
        if (evaluatedNode.isNumber()) {
            if (Number.class.isAssignableFrom(value.getClass())) {
                if (evaluatedNode.isIntegralNumber()) {
                    comparisonResult = Long.compare(evaluatedNode.asLong(), value.longValue());
                } else if (evaluatedNode.isFloatingPointNumber()) {
                    comparisonResult = Double.compare(evaluatedNode.asDouble(), value.doubleValue());
                }
            } else {
                throw new IllegalArgumentException("Type mismatch between operator and operand");
            }
        }
        return comparisonResult;
    }

    public static int compare(JsonNode evaluatedNode, Boolean value) {
        int comparisonResult = 0;
        if (evaluatedNode.isBoolean()) {
            if (Boolean.class.isAssignableFrom(value.getClass())) {
                Boolean bValue = Boolean.parseBoolean(value.toString());
                comparisonResult = Boolean.compare(evaluatedNode.asBoolean(), bValue);
            } else {
                throw new IllegalArgumentException("Type mismatch between operator and operand");
            }
        }
        return comparisonResult;
    }

    public static int compare(JsonNode evaluatedNode, String value) {
        int comparisonResult = 0;
        if (evaluatedNode.isTextual()) {
            if (String.class.isAssignableFrom(value.getClass())) {
                comparisonResult = evaluatedNode.asText().compareTo(String.valueOf(value));
            } else {
                throw new IllegalArgumentException("Type mismatch between operator and operand");
            }
        }
        return comparisonResult;
    }

    public static boolean compareForEquality(ExpressionEvaluationContext context, JsonNode evaluatedNode, Object value) {
        boolean nodeMissingOrNullCheck = ComparisonUtils.isNodeMissingOrNull(evaluatedNode);
        JsonNode jsonNode = mapper.valueToTree(JsonPath.read((String)context.getNode().toString(), (String)String.valueOf(value), (Predicate[])new Predicate[0]));
        if (ComparisonUtils.isNodeMissingOrNull(jsonNode)) {
            return nodeMissingOrNullCheck;
        }
        if (jsonNode.isNumber()) {
            if (jsonNode.isIntegralNumber()) {
                return !nodeMissingOrNullCheck && ComparisonUtils.compare(evaluatedNode, jsonNode.asLong()) == 0;
            }
            return !nodeMissingOrNullCheck && ComparisonUtils.compare(evaluatedNode, jsonNode.asDouble()) == 0;
        }
        if (jsonNode.isBoolean()) {
            return !nodeMissingOrNullCheck && ComparisonUtils.compare(evaluatedNode, jsonNode.asBoolean()) == 0;
        }
        if (jsonNode.isTextual()) {
            return !nodeMissingOrNullCheck && ComparisonUtils.compare(evaluatedNode, jsonNode.asText()) == 0;
        }
        return !nodeMissingOrNullCheck && ComparisonUtils.compare(evaluatedNode, jsonNode) == 0;
    }

    public static boolean compareForNotEquals(ExpressionEvaluationContext context, JsonNode evaluatedNode, Object value) {
        boolean nodeMissingOrNullCheck = ComparisonUtils.isNodeMissingOrNull(evaluatedNode);
        JsonNode jsonNode = mapper.valueToTree(JsonPath.read((String)context.getNode().toString(), (String)String.valueOf(value), (Predicate[])new Predicate[0]));
        if (ComparisonUtils.isNodeMissingOrNull(jsonNode)) {
            return !nodeMissingOrNullCheck;
        }
        if (jsonNode.isNumber()) {
            if (jsonNode.isIntegralNumber()) {
                return nodeMissingOrNullCheck || ComparisonUtils.compare(evaluatedNode, jsonNode.asLong()) != 0;
            }
            return nodeMissingOrNullCheck || ComparisonUtils.compare(evaluatedNode, jsonNode.asDouble()) != 0;
        }
        if (jsonNode.isBoolean()) {
            return nodeMissingOrNullCheck || ComparisonUtils.compare(evaluatedNode, jsonNode.asBoolean()) != 0;
        }
        if (jsonNode.isTextual()) {
            return nodeMissingOrNullCheck || ComparisonUtils.compare(evaluatedNode, jsonNode.asText()) != 0;
        }
        return nodeMissingOrNullCheck || ComparisonUtils.compare(evaluatedNode, jsonNode) != 0;
    }

    public static boolean isNodeMissingOrNull(JsonNode node) {
        return null == node || node.isMissingNode() || node.isNull();
    }

    public static boolean getDefaultResult(Boolean defaultResult, boolean resultIfNull) {
        if (null == defaultResult) {
            return resultIfNull;
        }
        return defaultResult;
    }
}

