/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.array;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.array.CollectionJsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class InExpression
extends CollectionJsonPathBasedExpression {
    public InExpression() {
        super(ExpressionType.in);
    }

    public InExpression(String path, Set<Object> values, boolean extractValues, String valuesPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.in, path, values, extractValues, valuesPath, defaultResult, preoperation);
    }

    @Override
    protected boolean evaluate(JsonNode evaluatedNode, Set<Object> values) {
        return !ComparisonUtils.isNodeMissingOrNull(evaluatedNode) && values.stream().anyMatch(value -> ComparisonUtils.compare(evaluatedNode, value) == 0);
    }

    public static InExpressionBuilder builder() {
        return new InExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InExpression)) {
            return false;
        }
        InExpression other = (InExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "InExpression(super=" + super.toString() + ")";
    }

    public static class InExpressionBuilder {
        private String path;
        private ArrayList<Object> values;
        private boolean extractValues;
        private String valuesPath;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        InExpressionBuilder() {
        }

        public InExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public InExpressionBuilder value(Object value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public InExpressionBuilder values(Collection<? extends Object> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public InExpressionBuilder clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public InExpressionBuilder extractValues(boolean extractValues) {
            this.extractValues = extractValues;
            return this;
        }

        public InExpressionBuilder valuesPath(String valuesPath) {
            this.valuesPath = valuesPath;
            return this;
        }

        public InExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public InExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public InExpression build() {
            Set<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptySet();
                    break;
                }
                case 1: {
                    values = Collections.singleton(this.values.get(0));
                    break;
                }
                default: {
                    values = new LinkedHashSet(this.values.size() < 0x40000000 ? 1 + this.values.size() + (this.values.size() - 3) / 3 : Integer.MAX_VALUE);
                    values.addAll(this.values);
                    values = Collections.unmodifiableSet(values);
                }
            }
            return new InExpression(this.path, values, this.extractValues, this.valuesPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "InExpression.InExpressionBuilder(path=" + this.path + ", values=" + this.values + ", extractValues=" + this.extractValues + ", valuesPath=" + this.valuesPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

