/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.numeric;

import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.numeric.NumericPreOperation;

public class SubtractOperation
extends NumericPreOperation {
    public SubtractOperation() {
        super(PreOperationType.subtract);
    }

    public SubtractOperation(Number operand) {
        super(PreOperationType.subtract, operand);
    }

    @Override
    public long compute(long leftOperand, long rightOperand) {
        return Long.sum(leftOperand, -1L * rightOperand);
    }

    @Override
    public double compute(double leftOperand, double rightOperand) {
        return Double.sum(leftOperand, -1.0 * rightOperand);
    }

    public static SubtractOperationBuilder builder() {
        return new SubtractOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubtractOperation)) {
            return false;
        }
        SubtractOperation other = (SubtractOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubtractOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SubtractOperation(super=" + super.toString() + ")";
    }

    public static class SubtractOperationBuilder {
        private Number operand;

        SubtractOperationBuilder() {
        }

        public SubtractOperationBuilder operand(Number operand) {
            this.operand = operand;
            return this;
        }

        public SubtractOperation build() {
            return new SubtractOperation(this.operand);
        }

        public String toString() {
            return "SubtractOperation.SubtractOperationBuilder(operand=" + this.operand + ")";
        }
    }
}

