/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.array;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.array.CollectionJsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ContainsAllExpression
extends CollectionJsonPathBasedExpression {
    public ContainsAllExpression() {
        super(ExpressionType.contains_all);
    }

    public ContainsAllExpression(String path, Set<Object> values, boolean extractValues, String valuesPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.contains_all, path, values, extractValues, valuesPath, defaultResult, null);
    }

    @Override
    protected boolean evaluate(JsonNode evaluatedNode, Set<Object> values) {
        if (!evaluatedNode.isArray()) {
            return false;
        }
        HashSet pathValues = new HashSet((Collection)JsonPath.read((String)evaluatedNode.toString(), (String)"$", (Predicate[])new Predicate[0]));
        int commonElementsSize = Sets.intersection(values, pathValues).size();
        return commonElementsSize == pathValues.size();
    }

    public static ContainsAllExpressionBuilder builder() {
        return new ContainsAllExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainsAllExpression)) {
            return false;
        }
        ContainsAllExpression other = (ContainsAllExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ContainsAllExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ContainsAllExpression(super=" + super.toString() + ")";
    }

    public static class ContainsAllExpressionBuilder {
        private String path;
        private ArrayList<Object> values;
        private boolean extractValues;
        private String valuesPath;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        ContainsAllExpressionBuilder() {
        }

        public ContainsAllExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ContainsAllExpressionBuilder value(Object value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public ContainsAllExpressionBuilder values(Collection<? extends Object> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public ContainsAllExpressionBuilder clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public ContainsAllExpressionBuilder extractValues(boolean extractValues) {
            this.extractValues = extractValues;
            return this;
        }

        public ContainsAllExpressionBuilder valuesPath(String valuesPath) {
            this.valuesPath = valuesPath;
            return this;
        }

        public ContainsAllExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public ContainsAllExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public ContainsAllExpression build() {
            Set<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptySet();
                    break;
                }
                case 1: {
                    values = Collections.singleton(this.values.get(0));
                    break;
                }
                default: {
                    values = new LinkedHashSet(this.values.size() < 0x40000000 ? 1 + this.values.size() + (this.values.size() - 3) / 3 : Integer.MAX_VALUE);
                    values.addAll(this.values);
                    values = Collections.unmodifiableSet(values);
                }
            }
            return new ContainsAllExpression(this.path, values, this.extractValues, this.valuesPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "ContainsAllExpression.ContainsAllExpressionBuilder(path=" + this.path + ", values=" + this.values + ", extractValues=" + this.extractValues + ", valuesPath=" + this.valuesPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

