/*
 * Decompiled with CFR 0.152.
 */
package io.async;

import io.async.AsyncIOException;
import io.async.SocketConnectionManager;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class Channel {
    private SocketConnectionManager scm;

    protected Channel(SocketConnectionManager scm) {
        this.scm = scm;
    }

    public int read() {
        byte[] result = new byte[1];
        int readCount = this.read(result, 0, 1);
        if (readCount >= 0) {
            return result[0];
        }
        return readCount;
    }

    public void read(IntConsumer onComplete, Consumer<Throwable> onFailure) {
        byte[] result = new byte[1];
        this.read(result, 0, 1, i -> {
            if (i >= 0) {
                onComplete.accept(result[0]);
            } else {
                onComplete.accept(i);
            }
        }, onFailure);
    }

    public int read(byte[] buffer, int pos, int maxLength) {
        SocketConnectionManager.ReadGuarder guarder = this.scm.read(this, buffer, pos, maxLength);
        if (guarder.isFinished(this.scm.getReadTimeOut() * 10L)) {
            if (!guarder.isReadFailed()) {
                return guarder.getReadCount();
            }
            throw new AsyncIOException("Read Failed", guarder.getReadException());
        }
        throw new AsyncIOException("read timeout");
    }

    public void read(byte[] buffer, int pos, int maxLength, IntConsumer onComplete, Consumer<Throwable> onFailure) {
        this.scm.read(this, buffer, pos, maxLength, onComplete, onFailure);
    }

    public void write(int value) {
        byte[] b = new byte[]{(byte)value};
        this.write(b);
    }

    public void write(int value, Consumer<Integer> onComplete, Consumer<Throwable> onFailure) {
        byte[] buffer = new byte[]{(byte)value};
        this.write(buffer, onComplete, onFailure);
    }

    public void write(byte[] buffer, int off, int length) {
        SocketConnectionManager.WriteGuarder guarder = this.scm.write(this, buffer, off, length);
        if (guarder.isFinished(this.scm.getWriteTimeOut() * 10)) {
            if (guarder.isWriteFailed()) {
                throw new AsyncIOException("Read Failed", guarder.getWriteException());
            }
        } else {
            throw new AsyncIOException("write timeout");
        }
    }

    public void write(byte[] buffer, int off, int length, Consumer<Integer> onComplete, Consumer<Throwable> onFailure) {
        this.scm.write(this, buffer, off, length, onComplete, onFailure);
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, Consumer<Integer> onComplete, Consumer<Throwable> onFailure) {
        this.write(buffer, 0, buffer.length, onComplete, onFailure);
    }

    public void close() {
        this.scm.disconnect(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.scm.disconnect(this);
    }
}

