(ns bloom.commons.debounce)

(defn debounce
  "Simple JS debouce. Given a function and a ms timeout, returns a new fn that only calls the given fn after ms have passed since the last invocation of the new fn"
  [f wait]
  (let [timeout (atom nil)]
    (fn [& args]
      (when-let [t @timeout]
        (js/clearTimeout t))
      (reset! timeout
              (js/setTimeout (fn [] (apply f args))
                             wait)))))
