(ns bloom.commons.muuntaja
  (:require
    [cognitect.transit])
  (:import
    [java.time.LocalDate]))

; https://github.com/metosin/muuntaja/issues/92

(def classes
  [['java.time.Duration str 'parse]
   ['java.time.Instant str 'parse]
   ['java.time.LocalDate str 'parse]
   ['java.time.LocalDateTime str 'parse]
   ['java.time.LocalTime str 'parse]
   ['java.time.MonthDay str 'parse]
   ['java.time.OffsetDateTime str 'parse]
   ['java.time.OffsetTime str 'parse]
   ['java.time.Period str 'parse]
   ['java.time.Year  str 'parse]
   ['java.time.YearMonth str 'parse]
   ['java.time.ZonedDateTime str 'parse]
   ['java.time.ZoneId  str 'of]
   ['java.time.ZoneOffset str 'of]
   ['java.time.DayOfWeek (memfn getValue) 'of]
   ['java.time.Month (memfn getValue) 'of]])

(def write-handlers
  (->> classes
       (map (fn [[c f _]]
              [(resolve c) (cognitect.transit/write-handler (name c) f)]))
       (into {})))

(def read-handlers
  (->> classes
       (map (fn [[c _ f]]
              [(name c) (cognitect.transit/read-handler (fn [r] (eval `(. ~c ~f ~r))))]))
       (into {})))
