(ns bloom.commons.html
  (:require
    [clojure.string :as string]
    [hiccup.core :as hiccup]))

(defn parse-opts
  "Given map of opts, rewrites any kebab-case opts to camelCase"
  [opts]
  (->> opts
       (map (fn [[k v]]
              [(string/replace (name k) #"-(\w)" "$1") v]))
       (into {})))

(defn parse [component]
  (cond
    (not (sequential? component))
    component

    ; [some-fn args]
    (fn? (first component))
    (let [[f & args] component]
      (parse (apply f args)))

    ; [:div {} & body]
    (and (keyword? (first component))
         (map? (second component)))
    (let [[tag opts & body] component]
      [tag (parse-opts opts) (map parse body)])

    ; [:div & body]
    (and (keyword? (first component)))
    (let [[tag & body] component]
      (parse (into [tag {}] body)))

    ; list of components
    :else
    (map parse component)))

(defn render [component]
  (hiccup/html
    (parse component)))

