(defproject io.bloomventures/commons :lein-v
  :dependencies [[reagent "0.8.1"]
                 [com.andrewmcveigh/cljs-time "0.5.2"]
                 [metosin/reitit-core "0.5.10"] ;; for: pages
                 [metosin/reitit-malli "0.5.10"] ;; for: pages
                 [venantius/accountant "0.2.5"] ;; for: pages
                 [metosin/malli "0.2.1"] ;; for: pages, config
                 [org.clojure/tools.reader "1.3.6"] ;; for: config
                 [borkdude/sci "0.2.0" ;; for :fn support in malli
                  :exclusions [org.clojure/tools.reader]] ;; newer for bugfix
                 [hiccup "1.0.5"] ;; for: html
                 [zprint "0.5.3"] ;; for: file-db
                 [com.ibm.icu/icu4j "62.1"] ;; for: slugify
                 [com.rpl/specter "1.1.3"] ;; for: just to have for all projects
                 [com.taoensso/timbre "4.1.0"] ;; for: just to have for all projects
                 [org.clojure/core.memoize "1.0.236"] ;; for: thread-safe-io
                 [cljs-ajax "0.8.0" ;; for: ajax
                  :exclusions [com.cognitect/transit-clj ;; newer in muuntaja
                               com.fasterxml.jackson.core/jackson-core ;; newer in muuntaja
                               commons-codec ;; newer in muuntaja
                               ]]
                 [com.cognitect/transit-cljs "0.8.264"] ;; for: ajax
                 [metosin/muuntaja "0.6.7"] ;; for: tada.rpc.server
                 [org.clojure/data.xml "0.0.8"] ;; for: aws.s3.core
                 [org.clj-commons/byte-streams "0.2.10"] ;; for: cache
                 ]

  :plugins [[com.roomkey/lein-v "7.0.0"]]
  :release-tasks [["vcs" "assert-committed"]
                  ["v" "update"]
                  ["vcs" "push"]
                  ["deploy" "clojars"]])
