(ns bloom.commons.aws.s3.media-element
  (:require
   [reagent.core :as r]))

(defn element
  [element-type]
  (fn [{:keys [on-load src lookup-fn] :as params}]
    (r/with-let [src-path (atom nil)
                 src* (r/atom "")
                 loading? (r/atom true)
                 on-load* (fn [e]
                            (reset! loading? false)
                            (when-let [l on-load]
                              (l e)))]
      (when (not= src @src-path)
        (reset! loading? true)
        (reset! src-path src)
        (lookup-fn @src-path (fn [u]
                               (reset! src* u)
                               (reset! loading? true))))
      [element-type
       (-> params
           (dissoc :lookup-fn)
           (assoc :src @src*
                  (case element-type
                    (:video :audio) :on-loaded-metadata
                    (:img :iframe) :on-load)
                  on-load*)
           (update :class (fn [cs]
                            (conj (cond
                                    (nil? cs) []
                                    (string? cs) [cs]
                                    :else cs)
                                  (when @loading? "loading")))))])))

(def audio (element :audio))

(def video (element :video))

(def img (element :img))

(def iframe (element :iframe))
