(ns bloom.commons.uuid
  "Provides clj+cljs functions for working with uuids.")

(defn random
  "Generates a random v4 UUID"
  []
  #?(:cljs (random-uuid)
     :clj (java.util.UUID/randomUUID)))

(defn from-string
  "Converts string representation of uuid into native UUID"
  [uuid-string]
  #?(:cljs (cljs.core/uuid uuid-string)
     :clj (java.util.UUID/fromString uuid-string)))

#?(:clj
   (defn from-email
     [email]
     (java.util.UUID/nameUUIDFromBytes (.getBytes email "UTF-8"))))

