(ns bloom.commons.crypto)

(defn slow=
  "Do a constant-time comparision check, to avoid timing attack"
  [as bs]
  (loop [as (seq as)
         bs (seq bs)
         eq? false]
    (if (and (empty? as) (empty? bs))
      eq?
      (recur (next as)
             (next bs)
             (= (first as) (first bs))))))
