(ns bloom.commons.slugify
  (:require
    [clojure.string :as string])
  #?(:clj
     (:import
       (com.ibm.icu.text Transliterator))))

#?(:clj
   (do
     (def transliterator
       (Transliterator/getInstance "Any-Latin; Latin-ASCII; Any-Lower"))

     (defn transliterate
       "Replaces characters in a given UTF-8 string with their lowercase ASCII equivalents.
       Ref:
       https://unicode-org.github.io/icu-docs/apidoc/released/icu4j/
       http://userguide.icu-project.org/transforms/general"
       [s]
       (.transliterate transliterator s))

     (defn slugify [s]
       (-> s
           (string/trim)
           transliterate
           ;; there's probably a way to define the following
           ;; directly in the transliterator above
           (string/replace #"\s" "-")
           (string/replace #"-+" "-")
           (string/replace #"[^a-z0-9-]" ""))))
   :cljs
   (defn slugify [s]
     (-> s
         (string/trim)
         (string/lower-case)
         (string/replace #"\s" "-")
         (string/replace #"-+" "-")
         (string/replace #"[^a-z0-9-]" ""))))
