(defproject io.bloomventures/commons :lein-v
  :description "kitchen-sink of micro-libs commonly used by bloom"
  :license {:name "Eclipse Public License - v 1.0"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :distribution :repo}
  :dependencies [[org.clojure/clojure "1.10.0"] ;; minimum, for map-entry in to work in textify
                 [reagent "0.8.1"]
                 [com.andrewmcveigh/cljs-time "0.5.2"]
                 [metosin/reitit-core "0.6.0"] ;; for: pages
                 [metosin/reitit-malli "0.6.0"] ;; for: pages
                 [venantius/accountant "0.2.5"] ;; for: pages
                 [metosin/malli "0.16.1"] ;; for: pages, config
                 [org.clojure/tools.reader "1.3.6"] ;; for: config
                 [org.babashka/sci "0.8.41" ;; for :fn support in malli
                  :exclusions [org.clojure/tools.reader]] ;; newer for bugfix
                 [io.github.escherize/huff "0.2.12"] ;; for: html
                 [zprint "1.3.0"] ;; for: file-db
                 [com.ibm.icu/icu4j "62.1"] ;; for: slugify
                 [com.rpl/specter "1.1.3"] ;; for: just to have for all projects
                 [com.taoensso/timbre "4.1.0"] ;; for: just to have for all projects
                 [org.clojure/core.memoize "1.0.236"] ;; for: thread-safe-io
                 [cljs-ajax "0.8.0" ;; for: ajax
                  :exclusions [com.cognitect/transit-clj ;; newer in muuntaja
                               com.fasterxml.jackson.core/jackson-core ;; newer in muuntaja
                               commons-codec ;; newer in muuntaja
                               ]]
                 [com.cognitect/transit-cljs "0.8.264"] ;; for: ajax
                 [metosin/muuntaja "0.6.7"] ;; for: tada.rpc.server
                 [org.clojure/data.xml "0.0.8"] ;; for: aws.s3.core
                 [org.clj-commons/byte-streams "0.2.10"] ;; for: cache

                 [tick/tick "0.7.5"]
                 [henryw374/js-joda "3.2.0-0"]
                 [henryw374/js-joda-locale-en-us "1.0.0-1"]
                 [cljsjs/js-joda-timezone "2.2.0-0"]]

  :plugins [[com.roomkey/lein-v "7.0.0"]]
  :release-tasks [["vcs" "assert-committed"]
                  ["v" "update"]
                  ["vcs" "push"]
                  ["deploy" "clojars"]])
