(ns bloom.commons.tada.rpc.server
  (:require
    [muuntaja.middleware :as muuntaja.middleware]
    [tada.events.ring]
    [bloom.commons.muuntaja :as mj]))

(defn make-handler
  [{:keys [extra-params] :as opts}]
  (-> (fn [request]
        (let [{:keys [event-id event-params]} (request :body-params)]
          (tada.events.ring/ring-dispatch-event!
            event-id
            (merge event-params
                   (extra-params request)))))
      (muuntaja.middleware/wrap-format
        (-> mj/options
            (update :formats select-keys ["application/transit+json"])
            (assoc :default-format "application/transit+json")))))
