(ns bloom.omni.fx.page
  (:require
    [re-frame.db :refer [app-db]]
    [re-frame.core :refer [reg-fx reg-sub]]))

(defn- db-get [k]
  (get-in @app-db [:omni/page k]))

(defn- db-set! [m]
  (swap! app-db update :omni/page merge m))

; usage:
; (require [bloom.omni.auth :as page])
; (page/register)


; {:page [:init! routes]}

(defn- init! [])

(defn- navigate! [])

(defn- dispatch-current! [])

(defn register []

  (reg-fx :omni/page
          (fn [[k & args]]
            (case k
              :init! (apply init! args)
              :navigate! (apply navigate! args)
              :dispatch-current! (apply dispatch-current! args))))

  (reg-event-fx :omni/set-page!
    (fn [db [_ k page-data]]
      (db-set!)
      
      ))

  (reg-sub :omni/page
    (fn [db _]
      
      )))
