(ns bloom.omni.static
  (:require
    [hiccup.core :as hiccup]))

(defn parse [component]
  (cond
    ; [some-fn args]
    (fn? (first component))
    (let [[f & args] component]
      (parse (apply f args)))
    
    ; [:div {} & body]
    (and (keyword? (first component))
         (map? (second component)))
    (let [[tag opts & body] component]
      [tag opts (map parse body)])

    ; [:div & body]
    (and (keyword? (first component)))
    (let [[tag & body] component]
      (parse (into [tag {}] body)))
    
    :else
    component))

(defn render [component]
  (hiccup/html 
    (parse component)))
