(ns io.clojure.tacular
  (:require [clojure.spec :as s])
  (:import [java.util.regex Pattern])
  )



(extend-type Pattern
  s/Specize
  (specize*
    ([s] s)
    ([s _] s))

  s/Spec
  (conform* [spec x]
    (if (and (string? x) (re-matches spec x))
      x
      ::s/invalid))
  (unform* [spec y] y)
  (explain* [spec path via in x])
  (gen* [spec overrides path rmap])
  (with-gen* [spec gfn])
  (describe* [spec])

  )

(comment
  (s/explain-data (s/nilable int?) "")
  (s/spec? #"")
  )
