package prism.internal;

import io.helidon.common.GenericType;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.Status;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.spi.Source;

// only necessary because of java interop bug/limitation: https://clojure.atlassian.net/browse/CLJ-1243#icft=CLJ-1243
public class HttpResponseDelegate implements HttpClientResponse {
    private final HttpClientResponse delegate;

    public HttpResponseDelegate(HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public ReadableEntity entity() {
        return delegate.entity();
    }

    public <T extends Source<?>> void source(GenericType<T> sourceType, T source) {
        delegate.source(sourceType, source);
    }

    public void close() {
        delegate.close();
    };

    public Status status() {
        return delegate.status();
    }

    public ClientResponseHeaders headers() {
        return delegate.headers();
    }

    public ClientResponseTrailers trailers() {
        return delegate.trailers();
    }

    public ClientUri lastEndpointUri() {
        return delegate.lastEndpointUri();
    }
}
