(ns prism.http-server
  (:require
    [prism.core :as prism]
    [prism.internal.classpath :as cp]
    [s-exp.hirundo :as hirundo]))

(defn- add-shutdown-hooks! [server]
  (.addShutdownHook (Runtime/getRuntime)
                    (Thread. #(do
                                (cp/when-ns 'taoensso.timbre
                                  (taoensso.timbre/info "Stopping server"))
                                (hirundo/stop! server)
                                (cp/when-ns 'prism.postgres
                                  (cp/when-ns 'taoensso.timbre
                                    (taoensso.timbre/info "Shutting down DB connection pool"))
                                  (.close (prism.postgres/data-src)))))))

(defn start-server! [handler & {:as opts}]
  (let [port (-> (prism/config) :port)
        server (->> (assoc opts :port port)
                    (hirundo/start! handler))]
    (add-shutdown-hooks! server)
    server))
