(ns prism.http-server
  (:require
    [prism.core :as prism]
    [prism.internal.classpath :as cp]
    [ring.adapter.jetty9 :as jetty])
  (:import
    (org.eclipse.jetty.server Server)))

(require 'ring.adapter.jetty9.http2) ;needs to be included at build time for graal, but is typically loaded lazily

(defn- configure-server [^Server server]
  (.addShutdownHook (Runtime/getRuntime)
                    (Thread. #(do
                                (cp/when-ns 'taoensso.timbre
                                  (taoensso.timbre/info "Stopping server"))
                                (.stop server)
                                (cp/when-ns 'prism.postgres
                                  (cp/when-ns 'taoensso.timbre
                                    (taoensso.timbre/info "Shutting down DB connection pool"))
                                  (.close (prism.postgres/data-src)))))))

(defn start-server! ^Server [handler & {:as jetty-opts}]
  (let [port (-> (prism/config) :port)]
    (cp/when-ns 'taoensso.timbre
      (taoensso.timbre/infof "Starting server on port %d" port))
    (->> (merge {:port                 port
                 :h2c?                 true
                 :join?                false
                 :virtual-threads?     true
                 :configurator         configure-server
                 :send-server-version? false} jetty-opts)
         (jetty/run-jetty handler))))
