(ns prism.http-client-protocol)

(defprotocol HttpClient
  (client-type [this])
  (request* [this req-map respond raise]))

(defn variable-client-request*-fn [default-client]
  (fn variable-client-request*
    ([req-map] (variable-client-request* req-map nil nil))
    ([req-map respond raise]
     (let [client (or (:http-client req-map) default-client)]
       (request* client req-map respond raise)))))
