(ns io.cvcf.frag.tailwind
  (:require
   [clojure.string :as str]
   [io.cvcf.frag.css :refer [>css]]))

(def component-types
  [:comp/image
   :comp/empty
   :f/image-wrapper
   :f/image-text
   :comp/link
   :comp/links
   :comp/copyright
   [:comp/heading {:importance (range 1 7)}]
   :comp/address
   :comp/text
   :comp/box
   :comp/social
   [:comp/list {:style [:ordered :unordered :plain]}]
   :comp/list-item
   :comp/hero
   :f/hero-wrapper
   :f/hero-overlay
   :f/hero-image
   :f/hero-text
   :comp/carousel
   [:comp/carousel-button {:direction [:left :right]}]
   :f/carousel-wrapper
   :comp/form
   :form/field
   :form/label
   :input/text
   :input/email
   :input/tel
   :input/longtext
   :input/select
   :input/submit])

(defn to-opts [ctype]
  (cond
    (keyword? ctype)
    (list {:type ctype})

    (vector? ctype)
    (let [[ctype args] ctype]
      (apply
       concat
       (map (fn [[component values]]
              (map (fn [x] {:type ctype component x}) values))
            args)))))

(defn classes [ctype]
  (apply concat (map >css (to-opts ctype))))

(def safelist
  (set (apply concat (map classes component-types))))

(defn write-safelist
  [outfile]
  (spit outfile (str/join "\n" safelist)))
