(ns io.cvcf.frag.u.names
  (:require
   [clojure.string :as str]))

(defn named?
  [s]
  ((some-fn string? keyword? symbol?) s))

(defn >name
  [s]
  (when (named? s) (name s)))

(defn >id
  [& [id & args]]
  (some->> (>name id)
           (conj args)
           (str/join "-")
           str/lower-case))
