(ns io.cvcf.frag.actions
  (:require
   [replicant.dom :as r]))

(defmulti execute-action (fn [[action & _] _] action))

(defmethod execute-action :carousel/prev
  [[_ args] _]
  (let [{:keys [index total]} @args]
    (reset! args {:index (mod (dec index) total) :total total})))

(defmethod execute-action :carousel/next
  [[_ args] _]
  (let [{:keys [index total]} @args]
    (reset! args {:index (mod (inc index) total) :total total})))

(defn execute-actions
  [event-data actions]
  (doseq [action actions]
    (execute-action action event-data)))

(r/set-dispatch!
 (fn [event-data actions]
   (execute-actions event-data actions)))
