(ns io.cvcf.frag.scenes.forms
  (:require
   [io.cvcf.frag.core :as f]
   [portfolio.replicant :as p :refer-macros [defscene]]))

(p/configure-scenes
 {:title "Form Components"})

(defscene form-field
  (f/render
   {:type :form/field
    :label "Full Name"
    :input :input/text
    :name "full-name"
    :required? true
    :placeholder "e.g. John Doe"}))

(defscene empty-form
  (f/render
   {:type :comp/form
    :url "/contact"
    :children
    [{:type :form/field
      :label "Full Name"
      :input :input/text
      :name "full-name"
      :required? true
      :placeholder "e.g. John Doe"}
     {:type :form/field
      :label "Email Address"
      :input :input/email
      :name "email-addr"
      :required? true
      :placeholder "e.g. my.email@email.com"}
     {:type :form/field
      :label "Phone Number"
      :input :input/tel
      :name "phone-num"
      :required? true
      :placeholder "e.g. 123.456.7890"}
     {:type :form/field
      :label "Message"
      :input :input/longtext
      :name "message"
      :class #{"flex-col"}
      :placeholder "e.g. Please send pricing info..."}
     {:type :input/submit
      :name "submit"
      :value "Submit"}]}))

(defscene populated-form
  (f/render
   {:type :comp/form
    :url "/contact"
    :children
    [{:type :input/text
      :name "full-name"
      :required? true
      :placeholder "e.g. John Doe"
      :value "Cameron Ch"}
     {:type :input/email
      :name "email-addr"
      :required? true
      :placeholder "e.g. my.email@email.com"
      :value "cameron@email.com"}
     {:type :input/tel
      :name "phone-num"
      :required? true
      :placeholder "e.g. 123.456.7890"}
     {:type :input/longtext
      :name "message"
      :placeholder "e.g. Please send pricing info..."}
     {:type :input/submit
      :name "submit"
      :value "Submit"}]}))

(defscene other-inputs
  (f/render
   {:type :comp/form
    :url "/test"
    :children
    [{:type :form/field
      :name "pick-num"
      :label "Pick a number"
      :input :input/select
      :children (range 5)}
     {:type :form/field
      :name "pick-word"
      :label "Pick a word"
      :input :input/select
      :children ["hello" "howdy" "greetings"]}]}))
