(ns io.cvcf.gentw
  (:require
   [babashka.process :refer [process destroy-tree]]
   [clojure.java.io :as io]))

(declare generate-css)
(defn build
  [& {:keys [in out] :or {in "input.css" out "output.css"}}]
  (-> (generate-css
       :in        in
       :out       out
       :watch?    false
       :minify?   false
       :optimize? false)
      :out
      println))

(defn release
  [& {:keys [in out] :or {in "input.css" out "output.css"}}]
  (-> (generate-css
       :in        in
       :out       out
       :watch?    false
       :minify?   true
       :optimize? true)
      :out
      println))

(defn watch
  [& {:keys [in out] :or {in "input.css" out "output.css"}}]
  (generate-css
   :in        in
   :out       out
   :watch?    true
   :minify?   false
   :optimize? false))

(defn generate-css
  "Generate CSS by calling the Tailwind CLI."
  [& {:keys [in out watch? minify? optimize?]
      :or   {in "input.css" out "output.css"}
      :as   args}]
  (let [infile  (.getAbsolutePath (io/file in))
        outfile (.getAbsolutePath (io/file out))]
    @(process
      {:out (if watch? :inherit :string)
       :err (if watch? :inherit :string)
       :shutdown destroy-tree}
      (format "yarn run tailwindcss --input %s --output %s%s%s%s"
              infile
              outfile
              (if watch?    " --watch"    "")
              (if minify?   " --minify"   "")
              (if optimize? " --optimize" "")))))
