/*
 * Decompiled with CFR 0.152.
 */
package czlab.basal;

import czlab.basal.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class XData
implements Serializable {
    private static final long serialVersionUID = -8637175588593032279L;
    private String _encoding = "utf-8";
    private boolean _cls = true;
    private Object _data = null;

    public XData(Object object, boolean bl) {
        this.reset(object, bl);
    }

    public XData(Object object) {
        this.reset(object);
    }

    public XData() {
        this(null);
    }

    public boolean isDeleteFile() {
        return this._cls;
    }

    public String encoding() {
        return this._encoding;
    }

    public XData setEncoding(String string) {
        this._encoding = string;
        return this;
    }

    public XData setDeleteFlag(boolean bl) {
        this._cls = bl;
        return this;
    }

    public void dispose() {
        if (this._cls && this._data instanceof File) {
            try {
                ((File)this._data).delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._data = null;
        }
        this.init();
    }

    public boolean isFile() {
        return this._data instanceof File;
    }

    public XData reset(Object object, boolean bl) {
        this.dispose();
        if (object instanceof ByteArrayOutputStream) {
            this._data = ((ByteArrayOutputStream)object).toByteArray();
        } else if (object instanceof CharArrayWriter) {
            this._data = ((CharArrayWriter)object).toCharArray();
        } else if (object instanceof File[]) {
            File[] fileArray = (File[])object;
            if (fileArray.length > 0) {
                this._data = fileArray[0];
            }
        } else if (object instanceof XData) {
            XData xData = (XData)object;
            this._encoding = xData._encoding;
            this._data = xData._data;
            this._cls = xData._cls;
            bl = xData._cls;
            xData._data = null;
        } else {
            this._data = object;
        }
        this.setDeleteFlag(bl);
        return this;
    }

    public XData reset(Object object) {
        return this.reset(object, true);
    }

    public boolean hasContent() {
        return this._data != null;
    }

    public Object content() {
        return this._data;
    }

    public byte[] getBytes() throws IOException {
        return this.getBytes(0xA00000);
    }

    public byte[] getBytes(int n) throws IOException {
        byte[] byArray;
        block17: {
            byArray = null;
            if (this._data instanceof File) {
                File file = (File)this._data;
                long l = file.length();
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    if (l > (long)n) {
                        throw new IOException("file too large, size= " + Long.toString(l));
                    }
                    byArray = new byte[(int)l];
                    ((InputStream)fileInputStream).read(byArray);
                    break block17;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception2) {
                    throw new IOException(exception2);
                }
            }
            if (this._data instanceof String) {
                byArray = ((String)this._data).getBytes(this._encoding);
            } else if (this._data instanceof byte[]) {
                byArray = (byte[])this._data;
            } else if (this._data instanceof char[]) {
                this._data = this.toBytes((char[])this._data);
                byArray = (byte[])this._data;
            } else if (this._data != null) {
                throw new IOException("can't getBytes on content");
            }
        }
        return byArray;
    }

    public File fileRef() {
        return this._data instanceof File ? (File)this._data : null;
    }

    public long size() throws IOException {
        long l = 0L;
        if (this._data instanceof File) {
            l = ((File)this._data).length();
        } else if (this._data instanceof byte[]) {
            l = ((byte[])this._data).length;
        } else if (this._data instanceof String) {
            try {
                l = ((String)this._data).getBytes(this._encoding).length;
            }
            catch (Exception exception2) {}
        } else if (this._data instanceof char[]) {
            this._data = this.toBytes((char[])this._data);
            l = ((byte[])this._data).length;
        } else if (this._data != null) {
            throw new IOException("can't getSize on content");
        }
        return l;
    }

    public void finalize() throws Throwable {
        this.dispose();
    }

    public String strit() throws IOException {
        return !this.hasContent() ? null : (this._data instanceof String ? this._data.toString() : new String(this.getBytes(), this._encoding));
    }

    public InputStream stream() throws IOException {
        InputStream inputStream = null;
        if (this._data instanceof File) {
            inputStream = new XStream((File)this._data, false);
        } else if (this.hasContent()) {
            inputStream = new ByteArrayInputStream(this.getBytes());
        }
        return inputStream;
    }

    private void init() {
        this._encoding = "utf-8";
        this._cls = true;
        this._data = null;
    }

    private byte[] toBytes(char[] cArray) {
        ByteBuffer byteBuffer = Charset.forName(this._encoding).encode(CharBuffer.wrap(cArray));
        return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }
}

