/*
 * Decompiled with CFR 0.152.
 */
package czlab.jasal;

import czlab.jasal.CU;
import czlab.jasal.Disposable;
import czlab.jasal.Startable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCore
extends ThreadPoolExecutor
implements RejectedExecutionHandler,
Startable,
Disposable {
    public static final Logger TLOG = LoggerFactory.getLogger(TCore.class);
    private AtomicInteger _seq = new AtomicInteger(0);
    private boolean _paused;
    private boolean _trace;
    private String _id = "";

    public TCore(final String string, int n, long l, boolean bl) {
        super(Math.max(1, n), Math.max(1, n), l, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread thread = new Thread(runnable);
                thread.setName(string + "#" + TCore.this._seq.incrementAndGet());
                thread.setContextClassLoader(classLoader);
                return thread;
            }
        });
        this.setRejectedExecutionHandler(this);
        this._trace = bl;
        this._id = string;
        this._paused = true;
        if (bl && CU.canLog()) {
            TLOG.debug("TCore#{} ctor: threads = {}", (Object)string, (Object)("" + this.getCorePoolSize()));
        }
    }

    public TCore(String string, int n, boolean bl) {
        this(string, n, 60000L, bl);
    }

    public TCore(String string, int n) {
        this(string, n, true);
    }

    public TCore(String string) {
        this(string, Runtime.getRuntime().availableProcessors() * 2);
    }

    @Override
    public Object start(Object object) {
        this._paused = false;
        return this;
    }

    @Override
    public Object start() {
        return this.start(null);
    }

    @Override
    public void stop() {
        this._paused = true;
    }

    @Override
    public void dispose() {
        this.stop();
        this.shutdown();
        if (this._trace && CU.canLog()) {
            TLOG.debug("TCore#{} disposed and shut down", (Object)this._id);
        }
    }

    @Override
    public void execute(Runnable runnable) {
        if (!this._paused) {
            super.execute(runnable);
        } else if (CU.canLog()) {
            TLOG.warn("Ignoring the runnable, core is not running");
        }
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        if (CU.canLog()) {
            TLOG.error("TCore#{} rejecting work!", (Object)this._id);
        }
    }

    @Override
    public String toString() {
        return "TCore#" + this._id + " with threads = " + this.getCorePoolSize();
    }
}

