/*
 * Decompiled with CFR 0.152.
 */
package czlab.jasal;

import czlab.jasal.CU;
import czlab.jasal.Disposable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStream
extends InputStream
implements Disposable {
    public static final Logger TLOG = LoggerFactory.getLogger(XStream.class);
    private transient InputStream _inp = null;
    private boolean _closed = true;
    private boolean _transientFile;
    private File _fn;
    private long pos = 0L;

    public XStream(File file, boolean bl) {
        this._transientFile = bl;
        this._fn = file;
    }

    public XStream(File file) {
        this(file, false);
    }

    @Override
    public int available() throws IOException {
        this.pre();
        return this._inp.available();
    }

    @Override
    public int read() throws IOException {
        this.pre();
        int n = this._inp.read();
        ++this.pos;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return -1;
        }
        this.pre();
        int n3 = this._inp.read(byArray, n, n2);
        this.pos = n3 == -1 ? -1L : this.pos + (long)n3;
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return byArray == null ? -1 : this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return -1L;
        }
        this.pre();
        long l2 = this._inp.skip(l);
        if (l2 > 0L) {
            this.pos += l2;
        }
        return l2;
    }

    @Override
    public void close() {
        try {
            if (this._inp != null) {
                this._inp.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._inp = null;
        this._closed = true;
    }

    @Override
    public void mark(int n) {
        if (this._inp != null) {
            this._inp.mark(n);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this._inp != null) {
            this._inp.reset();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public XStream setTransientFlag(boolean bl) {
        this._transientFile = bl;
        return this;
    }

    @Override
    public void dispose() {
        this.close();
        if (this._transientFile && this._fn != null) {
            try {
                this._fn.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._fn = null;
        }
    }

    public String filename() {
        try {
            return this._fn != null ? this._fn.getCanonicalPath() : "";
        }
        catch (IOException iOException) {
            if (CU.canLog()) {
                TLOG.error("", (Throwable)iOException);
            }
            return "";
        }
    }

    public String toString() {
        return this.filename();
    }

    public long getPosition() {
        return this.pos;
    }

    public void finalize() throws Throwable {
        this.dispose();
    }

    private void pre() {
        if (this._closed) {
            this.ready();
        }
    }

    private void ready() {
        block2: {
            this.close();
            try {
                this._inp = new FileInputStream(this._fn);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!CU.canLog()) break block2;
                TLOG.error("", (Throwable)fileNotFoundException);
            }
        }
        this._closed = false;
        this.pos = 0L;
        this.mark(0);
    }
}

