/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import czlab.basal.CU;
import czlab.nettio.InboundHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashHandler
extends InboundHandler {
    public static final Logger TLOG = LoggerFactory.getLogger(FlashHandler.class);
    private static final String XML = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\">\r\n<cross-domain-policy>\r\n  <site-control permitted-cross-domain-policies=\"master-only\"/>\r\n  <allow-access-from domain=\"*\" to-ports=\"*\" />\r\n</cross-domain-policy>\r\n";
    private static final AttributeKey<Integer> HINT = AttributeKey.newInstance((String)"flash-hint");
    private static final String FLASH_POLICY_REQ = "<policy-file-request/>";
    private static final char[] FLASH_CHS = "<policy-file-request/>".toCharArray();
    private static final int FLASH_LEN = FLASH_CHS.length;
    public static final String NAME = FlashHandler.class.getSimpleName();
    public static final FlashHandler shared = new FlashHandler();

    public static ChannelPipeline addBefore(ChannelPipeline channelPipeline, String string) {
        channelPipeline.addBefore(string, NAME, (ChannelHandler)shared);
        return channelPipeline;
    }

    public static ChannelPipeline addLast(ChannelPipeline channelPipeline) {
        channelPipeline.addLast(NAME, (ChannelHandler)shared);
        return channelPipeline;
    }

    protected FlashHandler() {
    }

    @Override
    public void onRead(ChannelHandlerContext channelHandlerContext, Channel channel, Object object) throws Exception {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = byteBuf = object instanceof ByteBuf ? (ByteBuf)object : null;
        if (CU.canLog()) {
            TLOG.debug("FlashHandler:channelRead called");
        }
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        Integer n = (Integer)channel.attr(HINT).get();
        ByteBuf byteBuf3 = byteBuf.copy();
        if (n == null) {
            n = 0;
        }
        int n2 = byteBuf3.readableBytes();
        int n3 = byteBuf3.readerIndex();
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            short s = byteBuf3.getUnsignedByte(n3 + i);
            char c = FLASH_CHS[n];
            if (c == s) {
                if ((n = Integer.valueOf(n + 1)) != FLASH_LEN) continue;
                this.finito(channelHandlerContext, channel, object, true);
                n4 = 1;
                break;
            }
            this.finito(channelHandlerContext, channel, object, false);
            n4 = 0;
            break;
        }
        if (n4 != 0) {
            ReferenceCountUtil.release((Object)object);
        }
        ReferenceCountUtil.release((Object)byteBuf3);
        if (n4 < 0 && n < FLASH_LEN) {
            channel.attr(HINT).set((Object)n);
        }
    }

    private void finito(ChannelHandlerContext channelHandlerContext, Channel channel, Object object, boolean bl) {
        channel.attr(HINT).set(null);
        if (bl) {
            if (CU.canLog()) {
                TLOG.debug("FlashHandler: reply back to client with policy info");
            }
            ByteBuf byteBuf = channelHandlerContext.alloc().directBuffer();
            byteBuf.writeCharSequence((CharSequence)XML, CharsetUtil.US_ASCII);
            channelHandlerContext.writeAndFlush((Object)byteBuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            if (CU.canLog()) {
                TLOG.debug("FlashHandler: removing self. finito!");
            }
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            channelHandlerContext.fireChannelRead(object);
        }
    }
}

