/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import czlab.basal.CU;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class H2Handler
extends Http2ConnectionHandler
implements Http2FrameListener {
    public static final Logger TLOG = LoggerFactory.getLogger(H2Handler.class);

    public H2Handler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
    }

    public void onError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable) {
        super.onError(channelHandlerContext, bl, throwable);
        if (CU.canLog()) {
            TLOG.error("", throwable);
        }
    }

    public void parWrite(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        super.write(channelHandlerContext, object, channelPromise);
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        super.userEventTriggered(channelHandlerContext, object);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        super.exceptionCaught(channelHandlerContext, throwable);
        if (CU.canLog()) {
            TLOG.error("", throwable);
        }
        channelHandlerContext.close();
    }

    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
        int n3 = byteBuf.readableBytes() + n2;
        this.onData(channelHandlerContext, n, byteBuf, n2, bl);
        return n3;
    }

    protected abstract void onData(ChannelHandlerContext var1, int var2, ByteBuf var3, int var4, boolean var5);

    protected abstract void onHeaders(ChannelHandlerContext var1, int var2, Http2Headers var3, int var4, boolean var5);

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
        this.onHeaders(channelHandlerContext, n, http2Headers, n2, bl);
    }

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
        this.onHeaders(channelHandlerContext, n, http2Headers, n3, bl2);
    }

    public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
    }

    public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
    }

    public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
    }

    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
    }

    public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) {
    }

    public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) {
    }

    public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
    }

    public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) {
    }

    public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
    }
}

