/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import czlab.basal.CU;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class DuplexHandler
extends ChannelDuplexHandler {
    public static final Logger TLOG = LoggerFactory.getLogger(DuplexHandler.class);
    private boolean _rel;

    protected DuplexHandler(boolean bl) {
        this._rel = bl;
    }

    protected DuplexHandler() {
        this(false);
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelActive(channelHandlerContext);
        this.onActive(channelHandlerContext);
    }

    protected void onWrite(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
    }

    protected void onHandlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    protected void onRead(ChannelHandlerContext channelHandlerContext, Channel channel, Object object) throws Exception {
    }

    protected void onError(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
    }

    protected void onWriteChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    protected void onInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    protected void onActive(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    protected void onUnreg(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    protected void onReg(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelInactive(channelHandlerContext);
        this.onInactive(channelHandlerContext);
    }

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelRegistered(channelHandlerContext);
        this.onReg(channelHandlerContext);
    }

    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelUnregistered(channelHandlerContext);
        this.onUnreg(channelHandlerContext);
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelWritabilityChanged(channelHandlerContext);
        this.onWriteChanged(channelHandlerContext);
    }

    protected Object preWrite(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        return object;
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (object == null) {
            super.write(channelHandlerContext, object, channelPromise);
            this.onWrite(channelHandlerContext, object, channelPromise);
        } else {
            Object object2 = this.preWrite(channelHandlerContext, object);
            if (object2 != null) {
                super.write(channelHandlerContext, object2, channelPromise);
                this.onWrite(channelHandlerContext, object2, channelPromise);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (CU.canLog()) {
            TLOG.error("", throwable);
        }
        this.onError(channelHandlerContext, throwable);
        channelHandlerContext.channel().close();
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (CU.canLog()) {
            TLOG.debug("user-event-triggered: {}", object != null ? object : "null");
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        try {
            this.onRead(channelHandlerContext, channelHandlerContext.channel(), object);
        }
        finally {
            if (this._rel) {
                ReferenceCountUtil.release((Object)object);
            }
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.onHandlerAdded(channelHandlerContext);
    }
}

