/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import czlab.basal.CU;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineConfigurator
extends ChannelInitializer {
    public static final Logger TLOG = LoggerFactory.getLogger(PipelineConfigurator.class);

    protected PipelineConfigurator() {
    }

    protected void initChannel(Channel channel) throws Exception {
        this.onInitChannel(channel.pipeline());
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        super.exceptionCaught(channelHandlerContext, throwable);
        if (CU.canLog()) {
            TLOG.error("", throwable);
        }
        try {
            this.onError(channelHandlerContext, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.handlerAdded(channelHandlerContext);
        try {
            this.onHandlerAdded(channelHandlerContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onError(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
    }

    protected void onHandlerAdded(ChannelHandlerContext channelHandlerContext) {
    }

    protected abstract void onInitChannel(ChannelPipeline var1);
}

