/*
 * Decompiled with CFR 0.152.
 */
package czlab.proto.mock.jms;

import czlab.proto.mock.jms.MockTextMessage;
import czlab.proto.mock.jms.MockTopicConnection;
import czlab.proto.mock.jms.MockTopicSubscriber;
import czlab.proto.mock.jms.MockUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MockTopicSession
implements TopicSession {
    private Map<String, TopicSubscriber> _subs = new HashMap<String, TopicSubscriber>();
    private volatile boolean _active = false;
    private MockTopicConnection _conn;
    private boolean _tx;
    private int _ack;

    public MockTopicSession(MockTopicConnection mockTopicConnection, boolean bl, int n) {
        this._conn = mockTopicConnection;
        this._tx = bl;
        this._ack = n;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return null;
    }

    public MapMessage createMapMessage() throws JMSException {
        return null;
    }

    public Message createMessage() throws JMSException {
        return null;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return null;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return null;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.createTextMessage("");
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return new MockTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        return false;
    }

    public int getAcknowledgeMode() throws JMSException {
        return 0;
    }

    public void commit() throws JMSException {
    }

    public void rollback() throws JMSException {
    }

    public void close() throws JMSException {
        this._active = false;
    }

    public void recover() throws JMSException {
    }

    public MessageListener getMessageListener() throws JMSException {
        return null;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
    }

    public void run() {
        String string = System.getProperty("czlab.proto.mock.jms.loopsecs", "1");
        final int n = 1000 * Integer.valueOf(string);
        this._active = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                while (MockTopicSession.this._active && MockTopicSession.this._conn.isActive()) {
                    try {
                        MockTopicSession.this.trigger();
                        Thread.sleep(n);
                    }
                    catch (Throwable throwable) {}
                }
                MockTopicSession.this._active = false;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void trigger() throws Exception {
        TextMessage textMessage = this.createTextMessage(MockUtils.makeNewTextMsg_x());
        textMessage.setJMSType("Mock-Topic-Type");
        for (TopicSubscriber topicSubscriber : this._subs.values()) {
            MessageListener messageListener = topicSubscriber.getMessageListener();
            if (messageListener == null) continue;
            messageListener.onMessage((Message)textMessage);
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        return null;
    }

    public Queue createQueue(String string) throws JMSException {
        return null;
    }

    public Topic createTopic(String string) throws JMSException {
        return null;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        MockTopicSubscriber mockTopicSubscriber = new MockTopicSubscriber(topic, "");
        this._subs.put(topic.getTopicName(), mockTopicSubscriber);
        return mockTopicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        return null;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        MockTopicSubscriber mockTopicSubscriber = new MockTopicSubscriber(topic, string);
        this._subs.put(topic.getTopicName(), mockTopicSubscriber);
        return mockTopicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return null;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return null;
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return null;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return null;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return null;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return null;
    }

    public void unsubscribe(String string) throws JMSException {
    }
}

