/*
 * Decompiled with CFR 0.152.
 */
package czlab.proto.mock.mail;

import czlab.proto.mock.mail.MockMsg;
import java.util.Random;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;

public class MockIMapFolder
extends Folder {
    private Random _rand = new Random(System.currentTimeMillis());
    private boolean _open = false;
    private int _count = 1;
    private String _name;

    public MockIMapFolder(String string, Store store) {
        super(store);
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._name;
    }

    public Folder getParent() throws MessagingException {
        return null;
    }

    public boolean exists() throws MessagingException {
        return true;
    }

    public Folder[] list(String string) throws MessagingException {
        return new Folder[0];
    }

    public char getSeparator() throws MessagingException {
        return '\u0000';
    }

    public int getType() throws MessagingException {
        return 0;
    }

    public boolean create(int n) throws MessagingException {
        return false;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public Folder getFolder(String string) throws MessagingException {
        return null;
    }

    public boolean delete(boolean bl) throws MessagingException {
        return false;
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        return false;
    }

    public void open(int n) throws MessagingException {
        this._open = true;
    }

    public void close(boolean bl) throws MessagingException {
        this._open = false;
    }

    public boolean isOpen() {
        return this._open;
    }

    public Flags getPermanentFlags() {
        return null;
    }

    public int getMessageCount() throws MessagingException {
        this._count = this._rand.nextInt(10);
        if (this._count < 1) {
            this._count = 1;
        }
        return this._count;
    }

    public Message getMessage(int n) throws MessagingException {
        if (n < 1) {
            throw new MessagingException("wrong message num: " + n);
        }
        try {
            return new MockMsg(this, n).newMimeMsg();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MessagingException(exception.getMessage());
        }
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
    }

    public Message[] expunge() throws MessagingException {
        return new Message[0];
    }
}

