/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Direction {
    RIGHT,
    LEFT,
    DOWN,
    UP;


    public Direction getInv() {
        if (this == RIGHT) {
            return LEFT;
        }
        if (this == LEFT) {
            return RIGHT;
        }
        if (this == DOWN) {
            return UP;
        }
        if (this == UP) {
            return DOWN;
        }
        throw new IllegalStateException();
    }

    public String getShortCode() {
        return this.name().substring(0, 1);
    }

    public static Direction fromChar(char c) {
        if (c == '<') {
            return LEFT;
        }
        if (c == '>') {
            return RIGHT;
        }
        if (c == '^') {
            return UP;
        }
        return DOWN;
    }

    public Direction clockwise() {
        if (this == RIGHT) {
            return DOWN;
        }
        if (this == LEFT) {
            return UP;
        }
        if (this == DOWN) {
            return LEFT;
        }
        if (this == UP) {
            return RIGHT;
        }
        throw new IllegalStateException();
    }

    public static Direction leftOrRight(Point2D point2D, Point2D point2D2) {
        if (point2D.getX() < point2D2.getX()) {
            return LEFT;
        }
        if (point2D.getX() > point2D2.getX()) {
            return RIGHT;
        }
        throw new IllegalArgumentException();
    }

    public static Direction fromVector(Point2D point2D, Point2D point2D2) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        if (d == d3 && d2 == d4) {
            return null;
        }
        if (d == d3) {
            if (d4 > d2) {
                return DOWN;
            }
            return UP;
        }
        if (d2 == d4) {
            if (d3 > d) {
                return RIGHT;
            }
            return LEFT;
        }
        throw new IllegalArgumentException("Not a H or V line!");
    }
}

