/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.Log;

public class FileUtils {
    private static AtomicInteger counter;

    public static void resetCounter() {
        counter = new AtomicInteger(0);
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file;
        if (!string2.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (counter == null) {
            file = File.createTempFile(string, string2);
        } else {
            String string3 = string + counter.addAndGet(1) + string2;
            file = new File(string3);
        }
        Log.info("Creating temporary file: " + file);
        file.deleteOnExit();
        return file;
    }

    private static void copyInternal(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    public static void copyToFile(File file, File file2) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        FileUtils.copyInternal(bufferedInputStream, bufferedOutputStream);
    }

    public static void copyToStream(File file, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        FileUtils.copyInternal(bufferedInputStream, bufferedOutputStream);
    }

    public static void copyToStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        FileUtils.copyInternal(bufferedInputStream, bufferedOutputStream);
    }

    public static void copyToFile(byte[] byArray, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static String readSvg(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        return FileUtils.readSvg(bufferedReader, true);
    }

    public static String readSvg(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return FileUtils.readSvg(bufferedReader, false);
    }

    private static String readSvg(BufferedReader bufferedReader, boolean bl) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        if (bl) {
            bufferedReader.close();
        }
        return stringBuilder.toString();
    }
}

