/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewpagedDiagram
extends AbstractPSystem {
    private final List<Diagram> diagrams = new ArrayList<Diagram>();

    public NewpagedDiagram(AbstractPSystem abstractPSystem, AbstractPSystem abstractPSystem2) {
        if (abstractPSystem instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        if (abstractPSystem2 instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        this.diagrams.add(abstractPSystem);
        this.diagrams.add(abstractPSystem2);
    }

    public String toString() {
        return super.toString() + " SIZE=" + this.diagrams.size() + " " + this.diagrams;
    }

    public Diagram getLastDiagram() {
        return this.diagrams.get(this.diagrams.size() - 1);
    }

    @Override
    public CommandExecutionResult executeCommand(Command command, BlocLines blocLines) {
        int n = this.diagrams.size();
        CommandExecutionResult commandExecutionResult = command.execute(this.diagrams.get(n - 1), blocLines);
        if (commandExecutionResult.getNewDiagram() instanceof NewpagedDiagram) {
            NewpagedDiagram newpagedDiagram = (NewpagedDiagram)commandExecutionResult.getNewDiagram();
            if (newpagedDiagram.size() != 2) {
                throw new IllegalStateException();
            }
            if (newpagedDiagram.diagrams.get(0) != this.diagrams.get(n - 1)) {
                throw new IllegalStateException();
            }
            this.diagrams.add(newpagedDiagram.diagrams.get(1));
            return commandExecutionResult.withDiagram(this);
        }
        return commandExecutionResult;
    }

    private int size() {
        return this.diagrams.size();
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        return this.diagrams.get(n).exportDiagram(outputStream, 0, fileFormatOption);
    }

    @Override
    public int getNbImages() {
        int n = 0;
        for (Diagram diagram : this.diagrams) {
            n += diagram.getNbImages();
        }
        return n;
    }

    @Override
    public DiagramDescription getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diagram diagram : this.diagrams) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(diagram.getDescription());
        }
        return new DiagramDescription(stringBuilder.toString());
    }

    @Override
    public String getWarningOrError() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diagram diagram : this.diagrams) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (diagram.getWarningOrError() == null) continue;
            stringBuilder.append(diagram.getWarningOrError());
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        for (Diagram diagram : this.diagrams) {
            ((AbstractPSystem)diagram).makeDiagramReady();
        }
    }

    @Override
    public String checkFinalError() {
        for (Diagram diagram : this.getDiagrams()) {
            String string = ((AbstractPSystem)diagram).checkFinalError();
            if (string == null) continue;
            return string;
        }
        return super.checkFinalError();
    }

    public final List<Diagram> getDiagrams() {
        return Collections.unmodifiableList(this.diagrams);
    }
}

