/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class OptionFlags {
    private static final OptionFlags singleton = new OptionFlags();
    public static boolean ALLOW_INCLUDE = true;
    public static final boolean USE_HECTOR = false;
    public static boolean ADD_NICE_FOR_DOT = false;
    public static final boolean STRICT_SELFMESSAGE_POSITION = true;
    public static final boolean FORCE_TEOZ = false;
    public static final boolean USE_INTERFACE_EYE1 = false;
    public static final boolean USE_INTERFACE_EYE2 = false;
    public static final boolean OMEGA_CROSSING = false;
    private boolean verbose;
    private boolean extractFromMetadata;
    private boolean word;
    private boolean systemExit;
    private boolean gui;
    private boolean quiet;
    private boolean checkDotError;
    private boolean printFonts;
    private boolean useSuggestEngine;
    private boolean encodesprite;
    private boolean dumpHtmlStats;
    private boolean dumpStats;
    private boolean loopStats;
    private boolean overwrite;
    private boolean enableStats = OptionFlags.defaultForStats();
    private String fileSeparator = "_";
    private long timeoutMs = 900000L;
    private File logData;
    private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

    public static void setMaxPixel(int n) {
        ImageBuilder.setMaxPixel(n);
    }

    public void reset() {
        this.reset(false);
        GraphvizUtils.setDotExecutable(null);
    }

    public final void setDotExecutable(String string) {
        GraphvizUtils.setDotExecutable(string);
    }

    private OptionFlags() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        this.verbose = false;
        this.extractFromMetadata = false;
        this.word = false;
        this.systemExit = bl;
        this.gui = false;
        this.quiet = false;
        this.checkDotError = false;
        this.printFonts = false;
        this.useSuggestEngine = true;
        this.encodesprite = false;
    }

    public boolean useJavaInsteadOfDot() {
        return false;
    }

    public static OptionFlags getInstance() {
        return singleton;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean isExtractFromMetadata() {
        return this.extractFromMetadata;
    }

    public final void setExtractFromMetadata(boolean bl) {
        this.extractFromMetadata = bl;
    }

    public final boolean isWord() {
        return this.word;
    }

    public final void setWord(boolean bl) {
        this.word = bl;
    }

    public final boolean isSystemExit() {
        return this.systemExit;
    }

    public final void setSystemExit(boolean bl) {
        this.systemExit = bl;
    }

    public final boolean isGui() {
        return this.gui;
    }

    public final void setGui(boolean bl) {
        this.gui = bl;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public final boolean isCheckDotError() {
        return this.checkDotError;
    }

    public final void setCheckDotError(boolean bl) {
        this.checkDotError = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData(File file, Diagram diagram) {
        String string = diagram.getWarningOrError();
        if (string == null) {
            return;
        }
        AtomicBoolean atomicBoolean = this.logDataInitized;
        synchronized (atomicBoolean) {
            Object object;
            if (this.logData == null && !this.logDataInitized.get()) {
                object = GraphvizUtils.getenvLogData();
                if (object != null) {
                    this.setLogData(new File((String)object));
                }
                this.logDataInitized.set(true);
            }
            if (this.logData == null) {
                return;
            }
            object = null;
            try {
                object = new PrintStream(new FileOutputStream(this.logData, true));
                ((PrintStream)object).println("Start of " + file.getName());
                ((PrintStream)object).println(string);
                ((PrintStream)object).println("End of " + file.getName());
                ((PrintStream)object).println();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.error("Cannot open " + this.logData);
                fileNotFoundException.printStackTrace();
            }
            finally {
                if (object != null) {
                    ((PrintStream)object).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogData(File file) {
        this.logData = file;
        file.delete();
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("Cannot open " + file);
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public final boolean isPrintFonts() {
        return this.printFonts;
    }

    public final void setPrintFonts(boolean bl) {
        this.printFonts = bl;
    }

    public final boolean isUseSuggestEngine() {
        return this.useSuggestEngine;
    }

    public final void setUseSuggestEngine(boolean bl) {
        this.useSuggestEngine = bl;
    }

    public final boolean isEncodesprite() {
        return this.encodesprite;
    }

    public final void setEncodesprite(boolean bl) {
        this.encodesprite = bl;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public final String getFileSeparator() {
        return this.fileSeparator;
    }

    public final void setFileSeparator(String string) {
        this.fileSeparator = string;
    }

    public final boolean isDumpHtmlStats() {
        return this.dumpHtmlStats;
    }

    public final void setDumpHtmlStats(boolean bl) {
        this.dumpHtmlStats = bl;
    }

    public final boolean isDumpStats() {
        return this.dumpStats;
    }

    public final void setDumpStats(boolean bl) {
        this.dumpStats = bl;
    }

    public final boolean isLoopStats() {
        return this.loopStats;
    }

    public final void setLoopStats(boolean bl) {
        this.loopStats = bl;
    }

    private static boolean defaultForStats() {
        return OptionFlags.isTrue(System.getProperty("PLANTUML_STATS")) || OptionFlags.isTrue(System.getenv("PLANTUML_STATS"));
    }

    private static boolean isTrue(String string) {
        return "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    public boolean isEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(boolean bl) {
        this.enableStats = bl;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    public final void setTimeoutMs(long l) {
        this.timeoutMs = l;
    }
}

