/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.eggs.PSystemWelcome;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.PSystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemError
extends AbstractPSystem {
    private final LineLocation higherErrorPosition;
    private final List<ErrorUml> printedErrors;
    private final List<String> debugLines = new ArrayList<String>();

    public PSystemError(UmlSource umlSource, ErrorUml errorUml, List<String> list) {
        this(umlSource, Collections.singletonList(errorUml), list);
    }

    private PSystemError(UmlSource umlSource, List<ErrorUml> list, List<String> list2) {
        this.setSource(umlSource);
        LineLocation lineLocation = this.getHigherErrorPosition2(ErrorUmlType.EXECUTION_ERROR, list);
        LineLocation lineLocation2 = this.getHigherErrorPosition2(ErrorUmlType.SYNTAX_ERROR, list);
        if (lineLocation == null && lineLocation2 == null) {
            throw new IllegalStateException();
        }
        if (lineLocation != null && (lineLocation2 == null || lineLocation.compareTo(lineLocation2) >= 0)) {
            this.higherErrorPosition = lineLocation;
            this.printedErrors = this.getErrorsAt2(lineLocation, ErrorUmlType.EXECUTION_ERROR, list);
        } else {
            this.higherErrorPosition = lineLocation2;
            this.printedErrors = this.getErrorsAt2(lineLocation2, ErrorUmlType.SYNTAX_ERROR, list);
        }
        if (list2 != null) {
            this.debugLines.addAll(list2);
        }
    }

    private String getSuggestColor(boolean bl) {
        if (bl) {
            return "black";
        }
        return "white";
    }

    private String getRed(boolean bl) {
        if (bl) {
            return "#CD0A0A";
        }
        return "red";
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.ATXT || fileFormatOption.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt uGraphicTxt = new UGraphicTxt();
            UmlCharArea umlCharArea = uGraphicTxt.getCharArea();
            umlCharArea.drawStringsLR(this.getTextStrings(), 0, 0);
            umlCharArea.print(new PrintStream(outputStream));
            return new ImageDataSimple(1, 1);
        }
        boolean bl = fileFormatOption.isUseRedForError();
        IEntityImage iEntityImage = GraphicStrings.createForError(this.getHtmlStrings(bl), bl);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, iEntityImage.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        TextBlock textBlock = this.getSource().getTotalLineCount() < 5 ? this.addWelcome(iEntityImage) : iEntityImage;
        int n2 = (int)(System.currentTimeMillis() / 60000L) % 60;
        if (n2 == 0) {
            textBlock = this.addMessage(textBlock);
        }
        imageBuilder.setUDrawable(textBlock);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), outputStream);
    }

    private TextBlockBackcolored getWelcome() throws IOException {
        return new PSystemWelcome(GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT).getGraphicStrings();
    }

    private TextBlock addWelcome(TextBlockBackcolored textBlockBackcolored) throws IOException {
        TextBlockBackcolored textBlockBackcolored2 = this.getWelcome();
        return TextBlockUtils.mergeTB(textBlockBackcolored2, textBlockBackcolored, HorizontalAlignment.LEFT);
    }

    private TextBlock addMessage(TextBlock textBlock) throws IOException {
        TextBlockBackcolored textBlockBackcolored = this.getMessage();
        TextBlock textBlock2 = TextBlockUtils.mergeTB(textBlockBackcolored, textBlock, HorizontalAlignment.LEFT);
        textBlock2 = TextBlockUtils.mergeTB(textBlock2, textBlockBackcolored, HorizontalAlignment.LEFT);
        return textBlock2;
    }

    private TextBlockBackcolored getMessage() {
        final UImage uImage = new UImage(PSystemVersion.getTime());
        final HtmlColorSimple htmlColorSimple = new HtmlColorSimple(new Color(uImage.getImage().getRGB(0, 0)), false);
        final double d = uImage.getWidth();
        final double d2 = uImage.getHeight();
        return new TextBlockBackcolored(){

            public void drawU(UGraphic uGraphic) {
                uGraphic.apply(new UTranslate(1.0, 1.0)).draw(uImage);
            }

            public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
                return null;
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d + 1.0, d2 + 1.0);
            }

            public HtmlColor getBackcolor() {
                return htmlColorSimple;
            }
        };
    }

    private List<String> getTextStrings() {
        String string22;
        ArrayList<String> arrayList = new ArrayList<String>(this.getStack());
        if (arrayList.size() > 0) {
            arrayList.add(" ");
        }
        for (String string22 : this.getPartialCode()) {
            arrayList.add(string22);
        }
        String string3 = this.getSource().getLine(this.higherErrorPosition);
        string22 = StringUtils.hideComparatorCharacters(string3);
        if (StringUtils.isNotEmpty(string22)) {
            arrayList.add(string22);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string3.length(); ++i) {
            stringBuilder.append("^");
        }
        arrayList.add(stringBuilder.toString());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ErrorUml iterator : this.printedErrors) {
            linkedHashSet.add(iterator.getError());
        }
        for (String string : linkedHashSet) {
            arrayList.add(" " + string);
        }
        boolean bl = true;
        for (String string : this.getSuggest()) {
            if (bl) {
                arrayList.add(" " + string);
            } else {
                arrayList.add(string);
            }
            bl = false;
        }
        arrayList.addAll(this.debugLines);
        return arrayList;
    }

    private List<String> getStack() {
        LineLocation lineLocation = this.getLineLocation();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (lineLocation != null) {
            this.append(arrayList, lineLocation);
            while (lineLocation.getParent() != null) {
                lineLocation = lineLocation.getParent();
                this.append(arrayList, lineLocation);
            }
        }
        return arrayList;
    }

    public LineLocation getLineLocation() {
        for (ErrorUml errorUml : this.printedErrors) {
            if (errorUml.getLineLocation() == null) continue;
            return errorUml.getLineLocation();
        }
        return null;
    }

    private void append(List<String> list, LineLocation lineLocation) {
        if (lineLocation.getDescription() != null) {
            list.add("[From " + lineLocation.getDescription() + " (line " + (lineLocation.getPosition() + 1) + ") ]");
        }
    }

    private List<String> getPartialCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IteratorCounter2 iteratorCounter2 = this.getSource().iterator2();
        while (iteratorCounter2.hasNext()) {
            CharSequence2 charSequence2 = (CharSequence2)iteratorCounter2.next();
            if (charSequence2.getLocation().compareTo(this.higherErrorPosition) >= 0) continue;
            arrayList.add(charSequence2.toString());
        }
        if (arrayList.size() > 4) {
            int n = arrayList.size() - 4 + 1;
            String string = n == 1 ? "... (skipping 1 line) ..." : "... (skipping " + n + " lines) ...";
            arrayList = new ArrayList(arrayList.subList(n, arrayList.size()));
            arrayList.add(0, string);
        }
        return arrayList;
    }

    private List<String> getHtmlStrings(boolean bl) {
        String string22;
        ArrayList<String> arrayList = new ArrayList<String>(this.getStack());
        if (arrayList.size() > 0) {
            arrayList.add("----");
        }
        for (String string22 : this.getPartialCode()) {
            arrayList.add(StringUtils.hideComparatorCharacters(string22));
        }
        String string3 = this.getSource().getLine(this.higherErrorPosition);
        string22 = StringUtils.hideComparatorCharacters(string3);
        if (StringUtils.isNotEmpty(string22)) {
            arrayList.add("<w:" + this.getRed(bl) + ">" + string22 + "</w>");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ErrorUml iterator : this.printedErrors) {
            linkedHashSet.add(iterator.getError());
        }
        for (String string : linkedHashSet) {
            arrayList.add(" <color:" + this.getRed(bl) + ">" + string + "</color>");
        }
        boolean bl2 = true;
        for (String string : this.getSuggest()) {
            if (bl2) {
                arrayList.add(" <color:" + this.getSuggestColor(bl) + "><i>" + string + "</i></color>");
            } else {
                arrayList.add("<color:" + this.getSuggestColor(bl) + ">" + StringUtils.hideComparatorCharacters(string) + "</color>");
            }
            bl2 = false;
        }
        arrayList.addAll(this.debugLines);
        return arrayList;
    }

    public List<String> getSuggest() {
        boolean bl = false;
        for (ErrorUml object : this.printedErrors) {
            if (!object.hasSuggest()) continue;
            bl = true;
        }
        if (!bl) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add("Did you mean:");
        for (ErrorUml errorUml : this.printedErrors) {
            if (!errorUml.hasSuggest()) continue;
            arrayList.add(errorUml.getSuggest().getSuggestedLine());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<ErrorUml> getErrors(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        LinkedHashSet<ErrorUml> linkedHashSet = new LinkedHashSet<ErrorUml>();
        for (ErrorUml errorUml : list) {
            if (errorUml.getType() != errorUmlType) continue;
            linkedHashSet.add(errorUml);
        }
        return linkedHashSet;
    }

    private LineLocation getHigherErrorPosition2(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        LineLocation lineLocation = null;
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (lineLocation != null && errorUml.getLineLocation().compareTo(lineLocation) <= 0) continue;
            lineLocation = errorUml.getLineLocation();
        }
        return lineLocation;
    }

    private List<ErrorUml> getErrorsAt2(LineLocation lineLocation, ErrorUmlType errorUmlType, List<ErrorUml> list) {
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (errorUml.getLineLocation().compareTo(lineLocation) != 0 || !StringUtils.isNotEmpty(errorUml.getError())) continue;
            arrayList.add(errorUml);
        }
        return arrayList;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Error)");
    }

    public final LineLocation getHigherErrorPosition2() {
        return this.higherErrorPosition;
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.unmodifiableCollection(this.printedErrors);
    }

    @Override
    public String getWarningOrError() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDescription());
        stringBuilder.append('\n');
        for (CharSequence charSequence : this.getTitle().getDisplay()) {
            stringBuilder.append(charSequence);
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        for (String string : this.getSuggest()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static PSystemError merge(Collection<PSystemError> collection) {
        UmlSource umlSource = null;
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PSystemError pSystemError : collection) {
            if (pSystemError == null) continue;
            if (pSystemError.getSource() != null && umlSource == null) {
                umlSource = pSystemError.getSource();
            }
            arrayList.addAll(pSystemError.getErrorsUml());
            arrayList2.addAll(pSystemError.debugLines);
            if (pSystemError.debugLines.size() <= 0) continue;
            arrayList2.add("-");
        }
        if (umlSource == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(umlSource, arrayList, arrayList2);
    }
}

