/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.GeneratedImageImpl;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileReader2
implements ISourceFileReader {
    private final File file;
    private final File outputFile;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader2(Defines defines, File file, File file2, List<String> list, String string, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        this.outputFile = file2;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        this.builder = new BlockUmlBuilder(list, string, defines, this.getReader(string), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            if (!(blockUml.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        ArrayList<GeneratedImageImpl> arrayList = new ArrayList<GeneratedImageImpl>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            SuggestedFile suggestedFile = SuggestedFile.fromOutputFile(this.outputFile, this.fileFormatOption.getFileFormat());
            Diagram diagram = blockUml.getDiagram();
            OptionFlags.getInstance().logData(this.file, diagram);
            for (FileImageData fileImageData : PSystemUtils.exportDiagrams(diagram, suggestedFile, this.fileFormatOption)) {
                String string = "[" + this.file.getName() + "] " + diagram.getDescription();
                GeneratedImageImpl generatedImageImpl = new GeneratedImageImpl(fileImageData.getFile(), string, blockUml);
                arrayList.add(generatedImageImpl);
            }
        }
        Log.info("Number of image(s): " + arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    private Reader getReader(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + string);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), string);
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<FileWithSuffix> getIncludedFiles2() {
        return this.builder.getIncludedFiles();
    }

    @Override
    public List<BlockUml> getBlocks() {
        return this.builder.getBlockUmls();
    }
}

