/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.version.PSystemVersion;

public class Splash
extends Window
implements MouseListener,
MouseMotionListener {
    private static final Color LINK_NORMAL = Color.BLUE;
    private static final Color LINK_HOVER = new Color(127, 0, 127);
    private static Splash singleton;
    private final int width = 280;
    private final int height = 80;
    private final BufferedImage logo;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger done = new AtomicInteger();
    private final AtomicInteger errors = new AtomicInteger();
    private final Font font = new Font("SansSerif", 1, 12);
    private int xClicked;
    private int yClicked;
    private int limY;
    private int limX;
    private Color link = LINK_NORMAL;

    public static void main(String[] stringArray) throws Exception {
        Splash.createSplash();
        Splash.incTotal(30);
        for (int i = 0; i < 20; ++i) {
            Splash.incDone(i > 3);
            Thread.sleep(1000L);
        }
    }

    private Splash() {
        super((Frame)null);
        this.logo = PSystemVersion.getPlantumlImage();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(dimension.getWidth() - 280.0) / 2;
        int n2 = (int)(dimension.getHeight() - 80.0) / 2;
        this.setBounds(n, n2, 280, 80);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getXOnScreen();
        int n2 = mouseEvent.getYOnScreen();
        this.setBounds(n - this.xClicked, n2 - this.yClicked, 280, 80);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getY() > this.limY && mouseEvent.getX() < this.limX) {
            this.updateLinkColor(LINK_HOVER);
        } else {
            this.updateLinkColor(LINK_NORMAL);
        }
    }

    private void updateLinkColor(Color color) {
        if (this.link != color) {
            this.link = color;
            this.setCursor(this.link == LINK_NORMAL ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.xClicked = mouseEvent.getX();
        this.yClicked = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.link != LINK_NORMAL) {
            try {
                Desktop.getDesktop().browse(new URL("http://plantuml.com").toURI());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        this.xClicked = mouseEvent.getX();
        this.yClicked = mouseEvent.getY();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateLinkColor(LINK_NORMAL);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    private void incTotalInternal(int n) {
        this.total.addAndGet(n);
        this.repaint();
    }

    private void incDoneInternal(boolean bl) {
        this.done.incrementAndGet();
        if (bl) {
            this.errors.incrementAndGet();
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 280, 80);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, 279, 79);
        graphics.drawRect(1, 1, 277, 77);
        graphics.drawImage(this.logo, 280 - this.logo.getWidth() - 4, 80 - this.logo.getHeight() - 4, null);
        this.drawProgessBar(graphics, this.done.intValue(), this.total.intValue());
        int n = this.errors.get();
        if (n > 0) {
            graphics.setColor(Color.RED);
            String string = "" + n + (n > 1 ? " diagrams" : " diagram") + " contains errors";
            graphics.drawString(string, 10, 20);
        }
        graphics.setColor(this.link);
        Rectangle2D rectangle2D = this.getUsed(graphics, "http://plantuml.com");
        graphics.drawString("http://plantuml.com", 10, (int)(80.0 - rectangle2D.getMaxY()));
        this.limY = (int)(80.0 - rectangle2D.getMaxY() + rectangle2D.getMinY());
        this.limX = (int)(10.0 + rectangle2D.getMaxX());
    }

    private void drawProgessBar(Graphics graphics, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        graphics.setFont(this.font);
        String string = "" + n + "/" + n2;
        Rectangle2D rectangle2D = this.getUsed(graphics, string);
        int n3 = (int)(rectangle2D.getHeight() + 2.0);
        graphics.setColor(new Color(230, 230, 230));
        int n4 = 170 * n / n2;
        graphics.fillRect(10, 33, n4, n3);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(10, 33, 170, n3);
        double d = 10.0 + (170.0 - rectangle2D.getWidth()) / 2.0;
        double d2 = 33.0 - rectangle2D.getY() + ((double)n3 - rectangle2D.getHeight()) / 2.0;
        graphics.drawString(string, (int)d, (int)d2);
    }

    private Rectangle2D getUsed(Graphics graphics, String string) {
        return graphics.getFontMetrics().getStringBounds(string, graphics);
    }

    public static synchronized void createSplash() {
        if (singleton == null) {
            singleton = new Splash();
        }
    }

    public static void incTotal(int n) {
        if (singleton != null) {
            singleton.incTotalInternal(n);
        }
    }

    public static void incDone(boolean bl) {
        if (singleton != null) {
            singleton.incDoneInternal(bl);
        }
    }

    public static synchronized void disposeSplash() {
        if (singleton != null) {
            singleton.setVisible(false);
            singleton.dispose();
            singleton = null;
        }
    }
}

