/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionBreak;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionEnd;
import net.sourceforge.plantuml.activitydiagram3.InstructionFork;
import net.sourceforge.plantuml.activitydiagram3.InstructionGoto;
import net.sourceforge.plantuml.activitydiagram3.InstructionGroup;
import net.sourceforge.plantuml.activitydiagram3.InstructionIf;
import net.sourceforge.plantuml.activitydiagram3.InstructionLabel;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.InstructionRepeat;
import net.sourceforge.plantuml.activitydiagram3.InstructionSimple;
import net.sourceforge.plantuml.activitydiagram3.InstructionSplit;
import net.sourceforge.plantuml.activitydiagram3.InstructionStart;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.InstructionWhile;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlanes;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockCompressed;
import net.sourceforge.plantuml.graphic.TextBlockRecentred;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ActivityDiagram3
extends UmlDiagram {
    private SwimlaneStrategy swimlaneStrategy;
    private final Swimlanes swinlanes = new Swimlanes(this.getSkinParam(), this.getPragma());
    private boolean hasUrl = false;

    private void manageSwimlaneStrategy() {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_FORBIDDEN;
        }
    }

    public CommandExecutionResult swimlane(String string, HtmlColor htmlColor, Display display) {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_ALLOWED;
        }
        if (this.swimlaneStrategy == SwimlaneStrategy.SWIMLANE_FORBIDDEN) {
            return CommandExecutionResult.error("This swimlane must be defined at the start of the diagram.");
        }
        this.swinlanes.swimlane(string, htmlColor, display);
        return CommandExecutionResult.ok();
    }

    private void setCurrent(Instruction instruction) {
        this.swinlanes.setCurrent(instruction);
    }

    private Instruction current() {
        return this.swinlanes.getCurrent();
    }

    private LinkRendering nextLinkRenderer() {
        return this.swinlanes.nextLinkRenderer();
    }

    public void addActivity(Display display, BoxStyle boxStyle, Url url, Colors colors) {
        this.manageSwimlaneStrategy();
        InstructionSimple instructionSimple = new InstructionSimple(display, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane(), boxStyle, url, colors);
        this.current().add(instructionSimple);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.manageHasUrl(display);
        if (url != null) {
            this.hasUrl = true;
        }
    }

    public CommandExecutionResult addGoto(String string) {
        InstructionGoto instructionGoto = new InstructionGoto(this.swinlanes.getCurrentSwimlane(), string);
        this.current().add(instructionGoto);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addLabel(String string) {
        InstructionLabel instructionLabel = new InstructionLabel(this.swinlanes.getCurrentSwimlane(), string);
        this.current().add(instructionLabel);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public void start() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionStart(this.swinlanes.getCurrentSwimlane()));
    }

    public void stop() {
        this.manageSwimlaneStrategy();
        InstructionStop instructionStop = new InstructionStop(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(instructionStop)) {
            return;
        }
        this.current().add(instructionStop);
    }

    public void end() {
        this.manageSwimlaneStrategy();
        InstructionEnd instructionEnd = new InstructionEnd(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(instructionEnd)) {
            return;
        }
        this.current().add(instructionEnd);
    }

    private boolean manageSpecialStopEndAfterEndWhile(Instruction instruction) {
        if (!(this.current() instanceof InstructionList)) {
            return false;
        }
        InstructionList instructionList = (InstructionList)this.current();
        Instruction instruction2 = instructionList.getLast();
        if (!(instruction2 instanceof InstructionWhile)) {
            return false;
        }
        ((InstructionWhile)instruction2).setSpecial(instruction);
        return true;
    }

    public void breakInstruction() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionBreak(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer()));
    }

    public DiagramDescription getDescription() {
        return new DiagramDescription("activity3");
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        TextBlock textBlock = new TextBlockCompressed(this.swinlanes);
        textBlock = new TextBlockRecentred(textBlock);
        ISkinParam iSkinParam = this.getSkinParam();
        textBlock = new AnnotatedWorker(this, iSkinParam).addAdd(textBlock);
        Dimension2D dimension2D = TextBlockUtils.getMinMax(textBlock, fileFormatOption.getDefaultStringBounder()).getDimension();
        double d = this.getDpiFactor(fileFormatOption, Dimension2DDouble.delta(dimension2D, 20.0, 0.0));
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), d, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(textBlock);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), outputStream);
    }

    private final double getDpiFactor(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        Scale scale = this.getScale();
        double d = scale == null ? this.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        return d;
    }

    public void fork() {
        InstructionFork instructionFork = new InstructionFork(this.current(), this.nextLinkRenderer(), this.getSkinParam());
        this.current().add(instructionFork);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionFork);
    }

    public CommandExecutionResult forkAgain() {
        if (this.current() instanceof InstructionFork) {
            InstructionFork instructionFork = (InstructionFork)this.current();
            instructionFork.manageOutRendering(this.nextLinkRenderer(), false);
            this.setNextLinkRendererInternal(LinkRendering.none());
            instructionFork.forkAgain();
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public CommandExecutionResult endFork(ForkStyle forkStyle, String string) {
        if (this.current() instanceof InstructionFork) {
            InstructionFork instructionFork = (InstructionFork)this.current();
            instructionFork.setStyle(forkStyle, string);
            instructionFork.manageOutRendering(this.nextLinkRenderer(), true);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(instructionFork.getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public void split() {
        InstructionSplit instructionSplit = new InstructionSplit(this.current(), this.nextLinkRenderer());
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.current().add(instructionSplit);
        this.setCurrent(instructionSplit);
    }

    public CommandExecutionResult splitAgain() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).splitAgain(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public CommandExecutionResult endSplit() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).endSplit(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionSplit)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public void startIf(Display display, Display display2, HtmlColor htmlColor) {
        this.manageSwimlaneStrategy();
        InstructionIf instructionIf = new InstructionIf(this.swinlanes.getCurrentSwimlane(), this.current(), display, display2, this.nextLinkRenderer(), htmlColor, this.getSkinParam());
        this.current().add(instructionIf);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionIf);
    }

    public CommandExecutionResult elseIf(Display display, Display display2, Display display3, HtmlColor htmlColor) {
        if (this.current() instanceof InstructionIf) {
            boolean bl = ((InstructionIf)this.current()).elseIf(display, display2, display3, this.nextLinkRenderer(), htmlColor);
            if (!bl) {
                return CommandExecutionResult.error("You cannot put an elseIf here");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult else2(Display display) {
        if (this.current() instanceof InstructionIf) {
            boolean bl = ((InstructionIf)this.current()).swithToElse2(display, this.nextLinkRenderer());
            if (!bl) {
                return CommandExecutionResult.error("Cannot find if");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult endif() {
        if (this.current() instanceof InstructionIf) {
            ((InstructionIf)this.current()).endif(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionIf)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public void startRepeat(HtmlColor htmlColor, Display display) {
        this.manageSwimlaneStrategy();
        InstructionRepeat instructionRepeat = new InstructionRepeat(this.swinlanes.getCurrentSwimlane(), this.current(), this.nextLinkRenderer(), htmlColor, display);
        this.current().add(instructionRepeat);
        this.setCurrent(instructionRepeat);
        this.setNextLinkRendererInternal(LinkRendering.none());
    }

    public CommandExecutionResult repeatWhile(Display display, Display display2, Display display3, Display display4, Rainbow rainbow) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            LinkRendering linkRendering = new LinkRendering(rainbow).withDisplay(display4);
            instructionRepeat.setTest(display, display2, display3, this.nextLinkRenderer(), linkRendering);
            this.setCurrent(instructionRepeat.getParent());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public CommandExecutionResult backwardWhile(Display display) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            instructionRepeat.setBackward(display);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public void doWhile(Display display, Display display2, HtmlColor htmlColor) {
        this.manageSwimlaneStrategy();
        InstructionWhile instructionWhile = new InstructionWhile(this.swinlanes.getCurrentSwimlane(), this.current(), display, this.nextLinkRenderer(), display2, htmlColor, this.getSkinParam());
        this.current().add(instructionWhile);
        this.setCurrent(instructionWhile);
    }

    public CommandExecutionResult endwhile(Display display) {
        if (this.current() instanceof InstructionWhile) {
            ((InstructionWhile)this.current()).endwhile(this.nextLinkRenderer(), display);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionWhile)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find while");
    }

    public final CommandExecutionResult kill() {
        if (!this.current().kill()) {
            return CommandExecutionResult.error("kill cannot be used here");
        }
        return CommandExecutionResult.ok();
    }

    public void startGroup(Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.manageSwimlaneStrategy();
        InstructionGroup instructionGroup = new InstructionGroup(this.current(), display, htmlColor, htmlColor2, this.swinlanes.getCurrentSwimlane(), htmlColor3, this.nextLinkRenderer());
        this.current().add(instructionGroup);
        this.setCurrent(instructionGroup);
    }

    public CommandExecutionResult endGroup() {
        if (this.current() instanceof InstructionGroup) {
            this.setCurrent(((InstructionGroup)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find group");
    }

    private void setNextLinkRendererInternal(LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.swinlanes.setNextLinkRenderer(linkRendering);
    }

    private void setNextLink(LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        if (this.current() instanceof InstructionCollection) {
            Instruction instruction = ((InstructionCollection)this.current()).getLast();
            if (instruction instanceof InstructionWhile) {
                ((InstructionWhile)instruction).afterEndwhile(linkRendering);
            } else if (instruction instanceof InstructionIf) {
                ((InstructionIf)instruction).afterEndwhile(linkRendering);
            }
        }
        this.setNextLinkRendererInternal(linkRendering);
    }

    public void setLabelNextArrow(Display display) {
        if (this.current() instanceof InstructionWhile && ((InstructionWhile)this.current()).getLast() == null) {
            ((InstructionWhile)this.current()).overwriteYes(display);
            return;
        }
        this.setNextLinkRendererInternal(this.nextLinkRenderer().withDisplay(display));
    }

    public void setColorNextArrow(Rainbow rainbow) {
        if (rainbow == null) {
            return;
        }
        LinkRendering linkRendering = new LinkRendering(rainbow);
        this.setNextLink(linkRendering);
    }

    public CommandExecutionResult addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors) {
        boolean bl = this.current().addNote(display, notePosition, noteType, colors, this.swinlanes.getCurrentSwimlane());
        if (!bl) {
            return CommandExecutionResult.error("Cannot add note here");
        }
        this.manageHasUrl(display);
        return CommandExecutionResult.ok();
    }

    private void manageHasUrl(Display display) {
        if (display.hasUrl()) {
            this.hasUrl = true;
        }
    }

    public boolean hasUrl() {
        return this.hasUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SwimlaneStrategy {
        SWIMLANE_FORBIDDEN,
        SWIMLANE_ALLOWED;

    }
}

