/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionGroup
implements Instruction,
InstructionCollection {
    private final InstructionList list;
    private final Instruction parent;
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final HtmlColor titleColor;
    private final LinkRendering linkRendering;
    private final Display test;
    private PositionedNote note = null;

    public InstructionGroup(Instruction instruction, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane, HtmlColor htmlColor3, LinkRendering linkRendering) {
        this.list = new InstructionList(swimlane);
        this.linkRendering = linkRendering;
        this.parent = instruction;
        this.test = display;
        this.borderColor = htmlColor3;
        this.backColor = htmlColor;
        this.titleColor = htmlColor2;
    }

    @Override
    public void add(Instruction instruction) {
        this.list.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = this.list.createFtile(ftileFactory);
        if (this.note != null) {
            ftile = new FtileWithNotes(ftile, Collections.singleton(this.note), ftileFactory.skinParam());
        }
        return ftileFactory.createGroup(ftile, this.test, this.backColor, this.titleColor, null, this.borderColor);
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.list.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.linkRendering;
    }

    @Override
    public boolean addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors, Swimlane swimlane) {
        if (this.list.isEmpty()) {
            this.note = new PositionedNote(display, notePosition, noteType, colors, swimlane);
            return true;
        }
        return this.list.addNote(display, notePosition, noteType, colors, swimlane);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.list.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.list.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.list.getLast();
    }
}

